/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements.tools;

import de.lessvoid.nifty.spi.render.RenderFont;
import java.util.ArrayList;
import java.util.List;

public class TextBreak {
    private String[] words;
    private int width;
    private RenderFont font;

    public TextBreak(String line, int width, RenderFont font) {
        this.words = line.split(" ", -1);
        this.width = width;
        this.font = font;
    }

    public List<String> split() {
        if (this.isSingleLine()) {
            return this.singleResult();
        }
        return this.processWords();
    }

    private List<String> singleResult() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.words[0]);
        return result;
    }

    private List<String> processWords() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        String currentWord = "";
        String lastColorValue = null;
        StringBuffer currentLine = new StringBuffer();
        while (this.isValidIndex(i)) {
            int p;
            currentLine.setLength(0);
            int length = 0;
            while (this.isBelowLimit(length) && this.isValidIndex(i)) {
                currentWord = this.getWord(i);
                String colorValue = this.extractColorValue(currentWord);
                if (colorValue != null) {
                    lastColorValue = colorValue;
                }
                if (!this.isBelowLimit(length += this.font.getWidth(currentWord))) continue;
                currentLine.append(currentWord);
                ++i;
            }
            if (currentLine.length() > 0) {
                this.addResult(result, lastColorValue, currentLine.toString());
                continue;
            }
            String wordPart = currentWord;
            do {
                p = 0;
                while (!this.isBelowLimit(this.font.getWidth(wordPart)) && wordPart.length() > 0) {
                    wordPart = wordPart.substring(0, wordPart.length() - 1);
                    ++p;
                }
                this.addResult(result, lastColorValue, wordPart);
                wordPart = currentWord.substring(currentWord.length() - p);
                String colorValue = this.extractColorValue(wordPart);
                if (colorValue == null) continue;
                lastColorValue = colorValue;
            } while (p > 0);
            ++i;
        }
        return result;
    }

    private void addResult(List<String> result, String lastColorValue, String currentLine) {
        if (lastColorValue != null) {
            result.add(lastColorValue + currentLine);
        } else {
            result.add(currentLine);
        }
    }

    private boolean isValidIndex(int i) {
        return i < this.words.length;
    }

    private boolean isBelowLimit(int currentLineLength) {
        return currentLineLength < this.width;
    }

    private String getWord(int i) {
        String currentWord = this.words[i];
        if (i < this.words.length - 1) {
            currentWord = currentWord + " ";
        }
        return currentWord;
    }

    private boolean isSingleLine() {
        return this.words.length == 1 && this.isBelowLimit(this.font.getWidth(this.words[0]));
    }

    String extractColorValue(String text) {
        int end;
        if (text == null) {
            return null;
        }
        int start = text.lastIndexOf("\\#");
        if (start != -1 && (end = text.indexOf("#", start + 2)) != -1) {
            return text.substring(start, end + 1);
        }
        return null;
    }
}

