/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout.manager;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;

public class HorizontalLayout
implements LayoutManager {
    @Override
    public final void layoutElements(LayoutPart root, List<LayoutPart> children) {
        if (this.isInvalid(root, children)) {
            return;
        }
        int rootBoxX = this.getRootBoxX(root);
        int rootBoxY = this.getRootBoxY(root);
        int rootBoxWidth = this.getRootBoxWidth(root);
        int rootBoxHeight = this.getRootBoxHeight(root);
        int x = rootBoxX;
        for (int i = 0; i < children.size(); ++i) {
            int elementWidth;
            int elementHeight;
            LayoutPart current = children.get(i);
            Box box = current.getBox();
            BoxConstraints boxConstraints = current.getBoxConstraints();
            if (boxConstraints.getWidth() != null && boxConstraints.getWidth().hasHeightSuffix()) {
                elementHeight = this.processHeightConstraint(rootBoxHeight, box, boxConstraints, 0);
                box.setHeight(elementHeight);
                elementWidth = this.calcElementWidth(children, rootBoxWidth, boxConstraints, elementHeight);
                box.setWidth(elementWidth);
            } else if (this.hasHeightConstraint(boxConstraints) && boxConstraints.getHeight().hasWidthSuffix()) {
                elementWidth = this.calcElementWidth(children, rootBoxWidth, boxConstraints, 0);
                box.setWidth(elementWidth);
                elementHeight = this.processHeightConstraint(rootBoxHeight, box, boxConstraints, elementWidth);
                box.setHeight(elementHeight);
            } else {
                elementWidth = this.calcElementWidth(children, rootBoxWidth, boxConstraints, 0);
                box.setWidth(elementWidth);
                elementHeight = this.processHeightConstraint(rootBoxHeight, box, boxConstraints, 0);
                box.setHeight(elementHeight);
            }
            box.setY(this.processVerticalAlignment(rootBoxY, rootBoxHeight, box, boxConstraints));
            box.setX(x);
            x += elementWidth;
        }
    }

    private int processHeightConstraint(int rootBoxHeight, Box box, BoxConstraints constraint, int elementWidth) {
        if (this.hasHeightConstraint(constraint)) {
            if (constraint.getHeight().hasWidthSuffix()) {
                return constraint.getHeight().getValueAsInt(elementWidth);
            }
            return constraint.getHeight().getValueAsInt(rootBoxHeight);
        }
        return rootBoxHeight;
    }

    private boolean hasHeightConstraint(BoxConstraints constraint) {
        return constraint != null && constraint.getHeight() != null && !constraint.getHeight().hasWildcard();
    }

    private int calcElementWidth(List<LayoutPart> children, int rootBoxWidth, BoxConstraints boxConstraints, int elementHeight) {
        if (boxConstraints.getWidth() != null) {
            int h = (int)boxConstraints.getWidth().getValue(rootBoxWidth);
            if (boxConstraints.getWidth().hasHeightSuffix()) {
                h = (int)boxConstraints.getWidth().getValue(elementHeight);
            }
            if (h != -1) {
                return h;
            }
        }
        return this.getMaxNonFixedWidth(children, rootBoxWidth);
    }

    private int processVerticalAlignment(int rootBoxY, int rootBoxHeight, Box box, BoxConstraints boxConstraints) {
        if (VerticalAlign.center.equals((Object)boxConstraints.getVerticalAlign())) {
            return rootBoxY + (rootBoxHeight - box.getHeight()) / 2;
        }
        if (VerticalAlign.top.equals((Object)boxConstraints.getVerticalAlign())) {
            return rootBoxY;
        }
        if (VerticalAlign.bottom.equals((Object)boxConstraints.getVerticalAlign())) {
            return rootBoxY + (rootBoxHeight - box.getHeight());
        }
        return rootBoxY;
    }

    private int getMaxNonFixedWidth(List<LayoutPart> elements, int parentWidth) {
        int maxFixedWidth = 0;
        int fixedCount = 0;
        for (int i = 0; i < elements.size(); ++i) {
            LayoutPart p = elements.get(i);
            BoxConstraints original = p.getBoxConstraints();
            if (original.getWidth() == null || !original.getWidth().isPercentOrPixel()) continue;
            maxFixedWidth = (int)((float)maxFixedWidth + original.getWidth().getValue(parentWidth));
            ++fixedCount;
        }
        int notFixedCount = elements.size() - fixedCount;
        if (notFixedCount > 0) {
            return (parentWidth - maxFixedWidth) / notFixedCount;
        }
        return parentWidth - maxFixedWidth;
    }

    @Override
    public final SizeValue calculateConstraintWidth(LayoutPart root, List<LayoutPart> children) {
        return null;
    }

    @Override
    public final SizeValue calculateConstraintHeight(LayoutPart root, List<LayoutPart> children) {
        int newHeight = 0;
        for (LayoutPart e : children) {
            int partHeight = e.getBoxConstraints().getHeight().getValueAsInt(0.0f) - e.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight()) - e.getBoxConstraints().getPaddingBottom().getValueAsInt(root.getBox().getHeight());
            if (partHeight <= newHeight) continue;
            newHeight = partHeight;
        }
        return new SizeValue(newHeight + "px");
    }

    private boolean isInvalid(LayoutPart root, List<LayoutPart> children) {
        return root == null || children == null || children.size() == 0;
    }

    private int getRootBoxX(LayoutPart root) {
        return root.getBox().getX() + root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxY(LayoutPart root) {
        return root.getBox().getY() + root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight());
    }

    private int getRootBoxWidth(LayoutPart root) {
        return root.getBox().getWidth() - root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth()) - root.getBoxConstraints().getPaddingRight().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxHeight(LayoutPart root) {
        return root.getBox().getHeight() - root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight()) - root.getBoxConstraints().getPaddingBottom().getValueAsInt(root.getBox().getHeight());
    }
}

