/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.loaderv2.types.NiftyControlsType;
import de.lessvoid.nifty.loaderv2.types.NiftyStylesType;
import de.lessvoid.nifty.loaderv2.types.NiftyType;
import de.lessvoid.nifty.tools.TimeProvider;
import de.lessvoid.xml.lwxs.Schema;
import de.lessvoid.xml.xpp3.XmlParser;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xmlpull.mxp1.MXParser;

public class NiftyLoader {
    private Logger log = Logger.getLogger(NiftyLoader.class.getName());
    private Map<String, Schema> schemes = new Hashtable<String, Schema>();
    private TimeProvider timeProvider;
    private Nifty nifty;

    public NiftyLoader(Nifty nifty, TimeProvider timeProvider) {
        this.nifty = nifty;
        this.timeProvider = timeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NiftyType loadNiftyXml(String schemaId, InputStream inputStreamXml, Nifty nifty) throws Exception {
        try {
            long start = this.timeProvider.getMsTime();
            this.log.info("loading new nifty xml file with schemaId [" + schemaId + "]");
            XmlParser parser = new XmlParser(new MXParser());
            parser.read(inputStreamXml);
            NiftyType niftyType = (NiftyType)this.getSchema(schemaId).loadXml(parser);
            niftyType.loadStyles(this, nifty);
            niftyType.loadControls(this);
            long end = this.timeProvider.getMsTime();
            this.log.info("loaded nifty xml file with schemaId [" + schemaId + "] took [" + (end - start) + " ms]");
            NiftyType niftyType2 = niftyType;
            return niftyType2;
        }
        finally {
            inputStreamXml.close();
        }
    }

    public boolean validateNiftyXml(InputStream inputStreamXml) throws Exception {
        long start = this.timeProvider.getMsTime();
        this.validate(inputStreamXml);
        long end = this.timeProvider.getMsTime();
        this.log.info("validating nifty xml took [" + (end - start) + " ms]");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(InputStream inputStreamXml) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            Document document = parser.parse(inputStreamXml);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream schemaStream = this.nifty.getResourceAsStream("nifty-1.3.xsd");
            try {
                StreamSource schemaFile = new StreamSource(schemaStream);
                javax.xml.validation.Schema schema = factory.newSchema(schemaFile);
                Validator validator = schema.newValidator();
                validator.validate(new DOMSource(document));
            }
            finally {
                schemaStream.close();
            }
        }
        finally {
            inputStreamXml.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStyleFile(String schemaId, String styleFilename, NiftyType niftyType, Nifty nifty) throws Exception {
        this.log.info("loading new nifty style xml file [" + styleFilename + "] with schemaId [" + schemaId + "]");
        XmlParser parser = new XmlParser(new MXParser());
        InputStream stream = nifty.getResourceAsStream(styleFilename);
        try {
            parser.read(stream);
            NiftyStylesType niftyStylesType = (NiftyStylesType)this.getSchema(schemaId).loadXml(parser);
            niftyStylesType.loadStyles(this, niftyType, nifty, this.log);
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadControlFile(String schemaId, String controlFilename, NiftyType niftyType) throws Exception {
        this.log.info("loading new nifty controls xml file [" + controlFilename + "] with schemaId [" + schemaId + "]");
        XmlParser parser = new XmlParser(new MXParser());
        InputStream stream = this.nifty.getResourceAsStream(controlFilename);
        try {
            parser.read(stream);
            NiftyControlsType niftyControlsType = (NiftyControlsType)this.getSchema(schemaId).loadXml(parser);
            niftyControlsType.loadControls(this, niftyType);
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSchema(String schemaId, InputStream inputStreamSchema) throws Exception {
        try {
            Schema niftyXmlSchema = new Schema(this.nifty.getResourceLoader());
            XmlParser parser = new XmlParser(new MXParser());
            parser.read(inputStreamSchema);
            parser.nextTag();
            parser.required("nxs", niftyXmlSchema);
            this.schemes.put(schemaId, niftyXmlSchema);
        }
        finally {
            inputStreamSchema.close();
        }
    }

    private Schema getSchema(String schemaId) throws Exception {
        Schema niftyXmlSchema = this.schemes.get(schemaId);
        if (niftyXmlSchema == null) {
            throw new Exception("unknown schemaId [" + schemaId + "]");
        }
        return niftyXmlSchema;
    }
}

