/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.Prioritized;
import org.bushe.swing.event.ProxySubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;

public abstract class AbstractProxySubscriber
implements ProxySubscriber,
Prioritized {
    private Object proxiedSubscriber;
    private Method subscriptionMethod;
    private ReferenceStrength referenceStrength;
    private EventService eventService;
    private int priority;

    protected AbstractProxySubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, EventService es) {
        this(proxiedSubscriber, subscriptionMethod, referenceStrength, 0, es);
    }

    protected AbstractProxySubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, int priority, EventService es) {
        this.referenceStrength = referenceStrength;
        this.priority = priority;
        this.eventService = es;
        if (proxiedSubscriber == null) {
            throw new IllegalArgumentException("The realSubscriber cannot be null when constructing a proxy subscriber.");
        }
        if (subscriptionMethod == null) {
            throw new IllegalArgumentException("The subscriptionMethod cannot be null when constructing a proxy subscriber.");
        }
        this.proxiedSubscriber = ReferenceStrength.WEAK.equals((Object)referenceStrength) ? new WeakReference<Object>(proxiedSubscriber) : proxiedSubscriber;
        this.subscriptionMethod = subscriptionMethod;
    }

    public Object getProxiedSubscriber() {
        if (this.proxiedSubscriber instanceof WeakReference) {
            return ((WeakReference)this.proxiedSubscriber).get();
        }
        return this.proxiedSubscriber;
    }

    public Method getSubscriptionMethod() {
        return this.subscriptionMethod;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public ReferenceStrength getReferenceStrength() {
        return this.referenceStrength;
    }

    public int getPriority() {
        return this.priority;
    }

    public void proxyUnsubscribed() {
        this.proxiedSubscriber = null;
    }

    public final int hashCode() {
        throw new RuntimeException("Proxy subscribers are not allowed in Hash Maps, since the underlying values use Weak References thatmay disappear, the calculations may not be the same insuccessive calls as required by hashCode.");
    }

    protected void retryReflectiveCallUsingAccessibleObject(Object[] args, Method subscriptionMethod, Object obj, IllegalAccessException e, String message) {
        boolean accessibleTriedAndFailed = false;
        if (subscriptionMethod != null) {
            AccessibleObject[] accessibleMethod = new AccessibleObject[]{subscriptionMethod};
            try {
                AccessibleObject.setAccessible(accessibleMethod, true);
                subscriptionMethod.invoke(obj, args);
                return;
            }
            catch (SecurityException ex) {
                accessibleTriedAndFailed = true;
            }
            catch (InvocationTargetException e1) {
                throw new RuntimeException(message, e);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(message, e);
            }
        }
        if (accessibleTriedAndFailed) {
            message = message + ".  An attempt was made to make the method accessible, but the SecurityManager denied the attempt.";
        }
        throw new RuntimeException(message, e);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractProxySubscriber) {
            AbstractProxySubscriber bps = (AbstractProxySubscriber)obj;
            if (this.referenceStrength != bps.referenceStrength) {
                return false;
            }
            if (this.subscriptionMethod != bps.subscriptionMethod) {
                return false;
            }
            if (ReferenceStrength.WEAK == this.referenceStrength ? ((WeakReference)this.proxiedSubscriber).get() != ((WeakReference)bps.proxiedSubscriber).get() : this.proxiedSubscriber != bps.proxiedSubscriber) {
                return false;
            }
            return this.eventService == bps.eventService;
        }
        return false;
    }

    public String toString() {
        return "AbstractProxySubscriber{realSubscriber=" + (this.proxiedSubscriber instanceof WeakReference ? ((WeakReference)this.proxiedSubscriber).get() : this.proxiedSubscriber) + ", subscriptionMethod=" + this.subscriptionMethod + ", referenceStrength=" + (Object)((Object)this.referenceStrength) + ", eventService=" + this.eventService + '}';
    }
}

