/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ClasspathPattern {
    private final List<String> _patterns = new ArrayList<String>();
    private final List<Entry> _entries = new ArrayList<Entry>();

    public ClasspathPattern() {
    }

    public ClasspathPattern(String[] patterns) {
        this.setPatterns(patterns);
    }

    public ClasspathPattern(String pattern) {
        this.setPattern(pattern);
    }

    private void setPatterns(String[] patterns) {
        this._patterns.clear();
        this._entries.clear();
        this.addPatterns(patterns);
    }

    private void addPatterns(String[] patterns) {
        if (patterns != null) {
            Entry entry = null;
            for (String pattern : patterns) {
                entry = this.createEntry(pattern);
                if (entry == null) continue;
                this._patterns.add(pattern);
                this._entries.add(entry);
            }
        }
    }

    private Entry createEntry(String pattern) {
        String item;
        Entry entry = null;
        if (pattern != null && (item = pattern.trim()).length() > 0) {
            entry = new Entry();
            entry.result = !item.startsWith("-");
            entry.partial = item.endsWith(".");
            entry.classpath = entry.result ? item : item.substring(1).trim();
        }
        return entry;
    }

    public void setPattern(String pattern) {
        this._patterns.clear();
        this._entries.clear();
        this.addPattern(pattern);
    }

    public void addPattern(String pattern) {
        ArrayList<String> patterns = new ArrayList<String>();
        StringTokenizer entries = new StringTokenizer(pattern, ":,");
        while (entries.hasMoreTokens()) {
            patterns.add(entries.nextToken());
        }
        this.addPatterns(patterns.toArray(new String[patterns.size()]));
    }

    public String[] getPatterns() {
        String[] patterns = null;
        if (this._patterns != null && this._patterns.size() > 0) {
            patterns = this._patterns.toArray(new String[this._patterns.size()]);
        }
        return patterns;
    }

    public boolean match(String name) {
        boolean result = false;
        if (this._entries != null) {
            name = name.replace('/', '.');
            name = name.replaceFirst("^[.]+", "");
            name = name.replaceAll("\\$.*$", "");
            for (Entry entry : this._entries) {
                if (entry == null) continue;
                if (entry.partial) {
                    if (!name.startsWith(entry.classpath)) continue;
                    result = entry.result;
                    break;
                }
                if (!name.equals(entry.classpath)) continue;
                result = entry.result;
                break;
            }
        }
        return result;
    }

    private static class Entry {
        public String classpath = null;
        public boolean result = false;
        public boolean partial = false;

        private Entry() {
        }
    }
}

