/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.resource.Resource;

public interface HttpContent {
    public HttpField getContentType();

    public String getContentTypeValue();

    public String getCharacterEncoding();

    public MimeTypes.Type getMimeType();

    public HttpField getContentLength();

    public long getContentLengthValue();

    public HttpField getLastModified();

    public String getLastModifiedValue();

    public HttpField getETag();

    public String getETagValue();

    public ByteBuffer getIndirectBuffer();

    public ByteBuffer getDirectBuffer();

    public Resource getResource();

    public InputStream getInputStream() throws IOException;

    public ReadableByteChannel getReadableByteChannel() throws IOException;

    public void release();

    public static class ResourceAsHttpContent
    implements HttpContent {
        final Resource _resource;
        final String _contentType;
        final int _maxBuffer;
        final String _etag;

        public ResourceAsHttpContent(Resource resource, String contentType) {
            this(resource, contentType, -1, false);
        }

        public ResourceAsHttpContent(Resource resource, String contentType, int maxBuffer) {
            this(resource, contentType, maxBuffer, false);
        }

        public ResourceAsHttpContent(Resource resource, String contentType, boolean etag) {
            this(resource, contentType, -1, etag);
        }

        public ResourceAsHttpContent(Resource resource, String contentType, int maxBuffer, boolean etag) {
            this._resource = resource;
            this._contentType = contentType;
            this._maxBuffer = maxBuffer;
            this._etag = etag ? resource.getWeakETag() : null;
        }

        @Override
        public String getContentTypeValue() {
            return this._contentType;
        }

        @Override
        public HttpField getContentType() {
            return this._contentType == null ? null : new HttpField(HttpHeader.CONTENT_TYPE, this._contentType);
        }

        @Override
        public String getCharacterEncoding() {
            return this._contentType == null ? null : MimeTypes.getCharsetFromContentType(this._contentType);
        }

        @Override
        public MimeTypes.Type getMimeType() {
            return this._contentType == null ? null : MimeTypes.CACHE.get(MimeTypes.getContentTypeWithoutCharset(this._contentType));
        }

        @Override
        public HttpField getLastModified() {
            long lm = this._resource.lastModified();
            return lm >= 0L ? new HttpField(HttpHeader.LAST_MODIFIED, DateGenerator.formatDate(lm)) : null;
        }

        @Override
        public String getLastModifiedValue() {
            long lm = this._resource.lastModified();
            return lm >= 0L ? DateGenerator.formatDate(lm) : null;
        }

        @Override
        public ByteBuffer getDirectBuffer() {
            if (this._resource.length() <= 0L || (long)this._maxBuffer < this._resource.length()) {
                return null;
            }
            try {
                return BufferUtil.toBuffer(this._resource, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public HttpField getETag() {
            return this._etag == null ? null : new HttpField(HttpHeader.ETAG, this._etag);
        }

        @Override
        public String getETagValue() {
            return this._etag;
        }

        @Override
        public ByteBuffer getIndirectBuffer() {
            if (this._resource.length() <= 0L || (long)this._maxBuffer < this._resource.length()) {
                return null;
            }
            try {
                return BufferUtil.toBuffer(this._resource, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public HttpField getContentLength() {
            long l = this._resource.length();
            return l == -1L ? null : new HttpField.LongValueHttpField(HttpHeader.CONTENT_LENGTH, this._resource.length());
        }

        @Override
        public long getContentLengthValue() {
            return this._resource.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        @Override
        public ReadableByteChannel getReadableByteChannel() throws IOException {
            return this._resource.getReadableByteChannel();
        }

        @Override
        public Resource getResource() {
            return this._resource;
        }

        @Override
        public void release() {
            this._resource.close();
        }

        public String toString() {
            return String.format("%s@%x{r=%s}", this.getClass().getSimpleName(), this.hashCode(), this._resource);
        }
    }
}

