/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements SelectorManager.SelectableEndPoint {
    public static final Logger LOG = Log.getLogger(SelectChannelEndPoint.class);
    private final AtomicReference<State> _interestState = new AtomicReference<State>(State.UPDATED);
    private final AtomicBoolean _open = new AtomicBoolean();
    private final SelectorManager.ManagedSelector _selector;
    private final SelectionKey _key;
    private int _interestOps;
    private final Runnable _runUpdateKey = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.updateKey();
        }
    };

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey key, Scheduler scheduler, long idleTimeout) {
        super(scheduler, channel);
        this._selector = selector;
        this._key = key;
        this.setIdleTimeout(idleTimeout);
    }

    @Override
    protected boolean needsFill() {
        this.changeInterests(1);
        return false;
    }

    @Override
    protected void onIncompleteFlush() {
        this.changeInterests(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSelected() {
        State current;
        assert (this._selector.isSelectorThread());
        block7: while (true) {
            current = this._interestState.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing, state {} for {}", new Object[]{current, this});
            }
            switch (current) {
                case UPDATE_PENDING: 
                case UPDATED: {
                    int readyOps;
                    if (!this._interestState.compareAndSet(current, State.LOCKED)) continue block7;
                    try {
                        int newInterestOps;
                        readyOps = this._key.readyOps();
                        int oldInterestOps = this._interestOps;
                        this._interestOps = newInterestOps = oldInterestOps & ~readyOps;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("onSelected {}->{} for {}", oldInterestOps, newInterestOps, this);
                        }
                    }
                    finally {
                        this._interestState.set(State.UPDATE_PENDING);
                    }
                    if ((readyOps & 1) != 0) {
                        this.getFillInterest().fillable();
                    }
                    if ((readyOps & 4) != 0) {
                        this.getWriteFlusher().completeWrite();
                    }
                    return;
                }
                case LOCKED: {
                    Thread.yield();
                    continue block7;
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid state: " + (Object)((Object)current));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateKey() {
        State current;
        block7: while (true) {
            current = this._interestState.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating key, state {} for {}", new Object[]{current, this});
            }
            switch (current) {
                case UPDATE_PENDING: 
                case UPDATED: {
                    if (!this._interestState.compareAndSet(current, State.LOCKED)) continue block7;
                    try {
                        this.setKeyInterests();
                        return;
                    }
                    finally {
                        this._interestState.set(State.UPDATED);
                    }
                }
                case LOCKED: {
                    Thread.yield();
                    continue block7;
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid state: " + (Object)((Object)current));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeInterests(int operation) {
        State current;
        block7: while (true) {
            current = this._interestState.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Changing interests in state {} for {}", new Object[]{current, this});
            }
            switch (current) {
                case UPDATE_PENDING: 
                case UPDATED: {
                    if (!this._interestState.compareAndSet(current, State.LOCKED)) continue block7;
                    try {
                        int oldInterestOps = this._interestOps;
                        int newInterestOps = oldInterestOps | operation;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("changeInterests s={} {}->{} for {}", new Object[]{current, oldInterestOps, newInterestOps, this});
                        }
                        if (newInterestOps != oldInterestOps) {
                            this._interestOps = newInterestOps;
                        }
                        if (current == State.UPDATED) {
                            this._selector.submit(this._runUpdateKey);
                        }
                    }
                    finally {
                        this._interestState.set(State.UPDATE_PENDING);
                    }
                    return;
                }
                case LOCKED: {
                    Thread.yield();
                    continue block7;
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid state: " + (Object)((Object)current));
    }

    private void setKeyInterests() {
        try {
            int oldInterestOps = this._key.interestOps();
            int newInterestOps = this._interestOps;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key interests update {} -> {} for {}", oldInterestOps, newInterestOps, this);
            }
            if (oldInterestOps != newInterestOps) {
                this._key.interestOps(newInterestOps);
            }
        }
        catch (CancelledKeyException x) {
            LOG.debug("Ignoring key update for concurrently closed channel {}", this);
            this.close();
        }
        catch (Throwable x) {
            LOG.warn("Ignoring key update for " + this, x);
            this.close();
        }
    }

    @Override
    public void close() {
        if (this._open.compareAndSet(true, false)) {
            super.close();
            this._selector.destroyEndPoint(this);
        }
    }

    @Override
    public boolean isOpen() {
        return this._open.get();
    }

    @Override
    public void onOpen() {
        if (this._open.compareAndSet(false, true)) {
            super.onOpen();
        }
    }

    @Override
    public String toString() {
        try {
            boolean valid = this._key != null && this._key.isValid();
            int keyInterests = valid ? this._key.interestOps() : -1;
            int keyReadiness = valid ? this._key.readyOps() : -1;
            return String.format("%s{io=%d,kio=%d,kro=%d}", super.toString(), this._interestOps, keyInterests, keyReadiness);
        }
        catch (CancelledKeyException x) {
            return String.format("%s{io=%s,kio=-2,kro=-2}", super.toString(), this._interestOps);
        }
    }

    private static enum State {
        UPDATED,
        UPDATE_PENDING,
        LOCKED;

    }
}

