/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.npn.server;

import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NegotiatingServerConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NPNServerConnection
extends NegotiatingServerConnection
implements NextProtoNego.ServerProvider {
    private static final Logger LOG = Log.getLogger(NPNServerConnection.class);

    public NPNServerConnection(EndPoint endPoint, SSLEngine engine, Connector connector, List<String> protocols, String defaultProtocol) {
        super(connector, endPoint, engine, protocols, defaultProtocol);
        NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)this);
    }

    public void unsupported() {
        this.protocolSelected(this.getDefaultProtocol());
    }

    public List<String> protocols() {
        return this.getProtocols();
    }

    public void protocolSelected(String protocol) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} protocol selected {}", this, protocol);
        }
        this.setProtocol(protocol != null ? protocol : this.getDefaultProtocol());
        NextProtoNego.remove((SSLEngine)this.getSSLEngine());
    }

    @Override
    public void close() {
        NextProtoNego.remove((SSLEngine)this.getSSLEngine());
        super.close();
    }
}

