/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.transport.internal;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Locale;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.HttpSender;
import org.eclipse.jetty.fcgi.client.transport.HttpClientTransportOverFCGI;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.generator.ClientGenerator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.StringUtil;

public class HttpSenderOverFCGI
extends HttpSender {
    private final ClientGenerator generator;

    public HttpSenderOverFCGI(HttpChannel channel) {
        super(channel);
        HttpClient httpClient = channel.getHttpDestination().getHttpClient();
        this.generator = new ClientGenerator(httpClient.getByteBufferPool(), httpClient.isUseOutputDirectByteBuffers());
    }

    protected HttpChannelOverFCGI getHttpChannel() {
        return (HttpChannelOverFCGI)super.getHttpChannel();
    }

    protected void sendHeaders(HttpExchange exchange, ByteBuffer contentBuffer, boolean lastContent, Callback callback) {
        HttpRequest request = exchange.getRequest();
        HttpFields headers = request.getHeaders();
        HttpFields.Mutable fcgiHeaders = HttpFields.build();
        URI uri = request.getURI();
        String path = uri == null ? request.getPath() : uri.getRawPath();
        fcgiHeaders.put("DOCUMENT_URI", path);
        String query = uri == null ? null : uri.getRawQuery();
        fcgiHeaders.put("QUERY_STRING", query == null ? "" : query);
        HttpField httpField = headers.getField(HttpHeader.AUTHORIZATION);
        EnumSet<HttpHeader> toRemove = EnumSet.of(HttpHeader.AUTHORIZATION);
        if (httpField != null) {
            fcgiHeaders.put("AUTH_TYPE", httpField.getValue());
        }
        httpField = headers.getField(HttpHeader.CONTENT_LENGTH);
        toRemove.add(HttpHeader.CONTENT_LENGTH);
        fcgiHeaders.put("CONTENT_LENGTH", httpField == null ? "" : httpField.getValue());
        httpField = headers.getField(HttpHeader.CONTENT_TYPE);
        toRemove.add(HttpHeader.CONTENT_TYPE);
        fcgiHeaders.put("CONTENT_TYPE", httpField == null ? "" : httpField.getValue());
        fcgiHeaders.put("REQUEST_METHOD", request.getMethod());
        fcgiHeaders.put("SERVER_PROTOCOL", request.getVersion().asString());
        fcgiHeaders.put("GATEWAY_INTERFACE", "CGI/1.1");
        fcgiHeaders.put("SERVER_SOFTWARE", "Jetty/" + Jetty.VERSION);
        for (HttpField field : headers) {
            if (toRemove.contains(field.getHeader())) continue;
            String name = field.getName();
            String fcgiName = "HTTP_" + StringUtil.replace((String)name, (char)'-', (char)'_').toUpperCase(Locale.ENGLISH);
            fcgiHeaders.add(fcgiName, field.getValue());
        }
        HttpClientTransportOverFCGI transport = (HttpClientTransportOverFCGI)this.getHttpChannel().getHttpDestination().getHttpClient().getTransport();
        transport.customize((Request)request, fcgiHeaders);
        ByteBufferPool.Accumulator accumulator = new ByteBufferPool.Accumulator();
        int id = this.getHttpChannel().getRequest();
        if (contentBuffer.hasRemaining() || lastContent) {
            this.generator.generateRequestHeaders(accumulator, id, (HttpFields)fcgiHeaders);
            this.generator.generateRequestContent(accumulator, id, contentBuffer, lastContent);
        } else {
            this.generator.generateRequestHeaders(accumulator, id, (HttpFields)fcgiHeaders);
        }
        this.getHttpChannel().flush(accumulator, callback);
    }

    protected void sendContent(HttpExchange exchange, ByteBuffer contentBuffer, boolean lastContent, Callback callback) {
        if (contentBuffer.hasRemaining() || lastContent) {
            ByteBufferPool.Accumulator accumulator = new ByteBufferPool.Accumulator();
            int request = this.getHttpChannel().getRequest();
            this.generator.generateRequestContent(accumulator, request, contentBuffer, lastContent);
            this.getHttpChannel().flush(accumulator, callback);
        } else {
            callback.succeeded();
        }
    }
}

