/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.api;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public interface Session {
    default public CompletableFuture<Stream> newStream(HeadersFrame frame, Stream.Listener listener) {
        return Promise.Completable.with(p -> this.newStream(frame, (Promise<Stream>)p, listener));
    }

    public void newStream(HeadersFrame var1, Promise<Stream> var2, Stream.Listener var3);

    public int priority(PriorityFrame var1, Callback var2);

    default public CompletableFuture<Void> settings(SettingsFrame frame) {
        return Callback.Completable.with(c -> this.settings(frame, (Callback)c));
    }

    public void settings(SettingsFrame var1, Callback var2);

    public void ping(PingFrame var1, Callback var2);

    public boolean close(int var1, String var2, Callback var3);

    public boolean isClosed();

    public boolean isPushEnabled();

    public Collection<Stream> getStreams();

    public Stream getStream(int var1);

    @Deprecated
    public InetSocketAddress getLocalAddress();

    default public SocketAddress getLocalSocketAddress() {
        return this.getLocalAddress();
    }

    @Deprecated
    public InetSocketAddress getRemoteAddress();

    default public SocketAddress getRemoteSocketAddress() {
        return this.getRemoteAddress();
    }

    public CompletableFuture<Void> shutdown();

    public static interface Listener {
        default public Map<Integer, Integer> onPreface(Session session) {
            return null;
        }

        default public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
            return null;
        }

        default public void onSettings(Session session, SettingsFrame frame) {
        }

        default public void onPing(Session session, PingFrame frame) {
        }

        default public void onReset(Session session, ResetFrame frame) {
        }

        default public void onGoAway(Session session, GoAwayFrame frame) {
        }

        default public void onClose(Session session, GoAwayFrame frame, Callback callback) {
            callback.succeeded();
        }

        default public boolean onIdleTimeout(Session session) {
            return true;
        }

        default public void onFailure(Session session, Throwable failure, Callback callback) {
            callback.succeeded();
        }
    }
}

