/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.frames.GoAwayFrame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.parser.HeaderParser;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BodyParser {
    private static final Logger LOG = LoggerFactory.getLogger(BodyParser.class);
    private final HeaderParser headerParser;
    private final ParserListener listener;

    protected BodyParser(HeaderParser headerParser, ParserListener listener) {
        this.headerParser = headerParser;
        this.listener = listener;
    }

    protected ParserListener getParserListener() {
        return this.listener;
    }

    protected long getBodyLength() {
        return this.headerParser.getFrameLength();
    }

    public abstract Result parse(ByteBuffer var1);

    protected void emptyBody(ByteBuffer buffer) {
        this.sessionFailure(buffer, HTTP3ErrorCode.PROTOCOL_ERROR.code(), "invalid_frame", new IOException("invalid empty body frame"));
    }

    protected void sessionFailure(ByteBuffer buffer, long error, String reason, Throwable failure) {
        BufferUtil.clear((ByteBuffer)buffer);
        this.notifySessionFailure(error, reason, failure);
    }

    protected void notifySessionFailure(long error, String reason, Throwable failure) {
        try {
            this.listener.onSessionFailure(error, reason, failure);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    protected void notifyStreamFailure(long streamId, long error, Throwable failure) {
        try {
            this.listener.onStreamFailure(streamId, error, failure);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    protected void notifySettings(SettingsFrame frame) {
        try {
            this.listener.onSettings(frame);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    protected void notifyGoAway(GoAwayFrame frame) {
        try {
            this.listener.onGoAway(frame);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    public static enum Result {
        NO_FRAME,
        BLOCKED_FRAME,
        FRAGMENT_FRAME,
        WHOLE_FRAME;

    }
}

