/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.generator.MessageGenerator;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFlusher
extends IteratingCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MessageFlusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Entry> entries = new ArrayDeque<Entry>();
    private final ByteBufferPool.Accumulator accumulator = new ByteBufferPool.Accumulator();
    private final MessageGenerator generator;
    private Entry entry;

    public MessageFlusher(ByteBufferPool bufferPool, QpackEncoder encoder, boolean useDirectByteBuffers) {
        this.generator = new MessageGenerator(bufferPool, encoder, useDirectByteBuffers);
    }

    public boolean offer(QuicStreamEndPoint endPoint, Frame frame, Callback callback) {
        try (AutoLock ignored = this.lock.lock();){
            this.entries.offer(new Entry(endPoint, frame, callback));
        }
        return true;
    }

    protected IteratingCallback.Action process() {
        Frame frame;
        try (AutoLock ignored = this.lock.lock();){
            this.entry = this.entries.poll();
            if (this.entry == null) {
                IteratingCallback.Action action = IteratingCallback.Action.IDLE;
                return action;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", (Object)this.entry, (Object)this);
        }
        if ((frame = this.entry.frame) instanceof FlushFrame) {
            this.succeeded();
            return IteratingCallback.Action.SCHEDULED;
        }
        int generated = this.generator.generate(this.accumulator, this.entry.endPoint.getStreamId(), frame, this::failed);
        if (generated < 0) {
            return IteratingCallback.Action.SCHEDULED;
        }
        QuicStreamEndPoint endPoint = this.entry.endPoint;
        List buffers = this.accumulator.getByteBuffers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} buffers ({} bytes) for stream #{} on {}", new Object[]{buffers.size(), this.accumulator.getTotalLength(), endPoint.getStreamId(), this});
        }
        endPoint.write((Callback)this, buffers, Frame.isLast(frame));
        return IteratingCallback.Action.SCHEDULED;
    }

    public void succeeded() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("succeeded to write {} on {}", (Object)this.entry, (Object)this);
        }
        this.accumulator.release();
        this.entry.callback.succeeded();
        this.entry = null;
        super.succeeded();
    }

    public void failed(Throwable x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed to write {} on {}", new Object[]{this.entry, this, x});
        }
        this.accumulator.release();
        this.entry.callback.failed(x);
        this.entry = null;
        super.succeeded();
    }

    public Invocable.InvocationType getInvocationType() {
        return this.entry.callback.getInvocationType();
    }

    private static class Entry {
        private final QuicStreamEndPoint endPoint;
        private final Frame frame;
        private final Callback callback;

        private Entry(QuicStreamEndPoint endPoint, Frame frame, Callback callback) {
            this.endPoint = endPoint;
            this.frame = frame;
            this.callback = callback;
        }

        public String toString() {
            return String.format("%s#%d", this.frame, this.endPoint.getStreamId());
        }
    }

    public static class FlushFrame
    extends Frame {
        public FlushFrame() {
            super(null);
        }
    }
}

