/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jetty.logging.JettyAppender;
import org.eclipse.jetty.logging.JettyLevel;
import org.eclipse.jetty.logging.JettyLogger;
import org.eclipse.jetty.logging.JettyLoggerConfiguration;
import org.eclipse.jetty.logging.JettyLoggerFactoryMBean;
import org.eclipse.jetty.logging.StdErrAppender;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class JettyLoggerFactory
implements ILoggerFactory,
JettyLoggerFactoryMBean {
    private final JettyLoggerConfiguration configuration;
    private final JettyLogger rootLogger;
    private final ConcurrentMap<String, JettyLogger> loggerMap;

    public JettyLoggerFactory(JettyLoggerConfiguration config) {
        this.configuration = Objects.requireNonNull(config, "JettyLoggerConfiguration");
        this.loggerMap = new ConcurrentHashMap<String, JettyLogger>();
        StdErrAppender appender = new StdErrAppender(this.configuration);
        this.rootLogger = new JettyLogger(this, "ROOT", appender);
        this.loggerMap.put("ROOT", this.rootLogger);
        this.rootLogger.setLevel(this.configuration.getLevel("ROOT"));
    }

    public String jmxContext() {
        return this.configuration.getString("org.eclipse.jetty.logging.jmx.context", null);
    }

    public JettyLogger getJettyLogger(String name) {
        if (name.equals("ROOT")) {
            return this.getRootLogger();
        }
        return this.loggerMap.computeIfAbsent(name, this::createLogger);
    }

    public Logger getLogger(String name) {
        return this.getJettyLogger(name);
    }

    void walkChildrenLoggers(String parentName, Consumer<JettyLogger> childConsumer) {
        Object prefix = parentName;
        if (parentName.length() > 0 && !((String)prefix).endsWith(".")) {
            prefix = (String)prefix + ".";
        }
        for (JettyLogger logger : this.loggerMap.values()) {
            if (logger.getName().equals(parentName) || !logger.getName().startsWith((String)prefix)) continue;
            childConsumer.accept(logger);
        }
    }

    JettyLogger getRootLogger() {
        return this.rootLogger;
    }

    private JettyLogger createLogger(String name) {
        JettyAppender appender = this.rootLogger.getAppender();
        JettyLevel level = this.configuration.getLevel(name);
        boolean hideStacks = this.configuration.getHideStacks(name);
        return new JettyLogger(this, name, appender, level, hideStacks);
    }

    static <T> T walkParentLoggerNames(String startName, Function<String, T> nameFunction) {
        if (startName == null) {
            return null;
        }
        String nameSegment = startName;
        while (nameSegment.length() > 0) {
            T ret = nameFunction.apply(nameSegment);
            if (ret != null) {
                return ret;
            }
            int idx = nameSegment.lastIndexOf(46);
            if (idx < 0) break;
            nameSegment = nameSegment.substring(0, idx);
        }
        return nameFunction.apply("ROOT");
    }

    @Override
    public String[] getLoggerNames() {
        TreeSet names = new TreeSet(this.loggerMap.keySet());
        return names.toArray(new String[0]);
    }

    @Override
    public int getLoggerCount() {
        return this.loggerMap.size();
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        return JettyLoggerFactory.walkParentLoggerNames(loggerName, key -> {
            JettyLogger logger = (JettyLogger)this.loggerMap.get(key);
            if (logger != null) {
                return logger.getLevel().name();
            }
            return null;
        });
    }

    @Override
    public boolean setLoggerLevel(String loggerName, String levelName) {
        JettyLevel level = JettyLoggerConfiguration.toJettyLevel(loggerName, levelName);
        if (level == null) {
            return false;
        }
        JettyLogger jettyLogger = this.getJettyLogger(loggerName);
        jettyLogger.setLevel(level);
        return true;
    }
}

