/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.enforcer.rules;

import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

public class RequireOsgiCompatibleVersionRule
implements EnforcerRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            String packaging = (String)helper.evaluate("${project.packaging}");
            if ("pom".equals(packaging)) {
                return;
            }
            String version = (String)helper.evaluate("${project.version}");
            this.ensureValidOsgiVersion(version);
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public void ensureValidOsgiVersion(String version) throws EnforcerRuleException {
        if (version.endsWith("SNAPSHOT")) {
            return;
        }
        String[] parts = version.split("\\.");
        if (parts.length > 4) {
            throw new EnforcerRuleException("The version \"" + version + "\" does not conform to the OSGi version requirements.  It can't have more than 4 parts (#.#.#.*) - The '.' character has a special meaning");
        }
        if (parts.length < 3) {
            throw new EnforcerRuleException("The version \"" + version + "\" does not conform to the OSGi version requirements.  It must have 3 (or 4) parts (#.#.#.*)");
        }
        for (int i = 0; i < 3; ++i) {
            if (!StringUtils.isNumeric((String)parts[i])) {
                throw new EnforcerRuleException("The version \"" + version + "\" does not conform to the OSGi version requirements.  Part #" + (i + 1) + " \"" + parts[i] + "\" of an OSGi version must be a non-negative number (#.#.#.*).");
            }
            if (Integer.parseInt(parts[i]) >= 0) continue;
            throw new EnforcerRuleException("The version \"" + version + "\" does not conform to the OSGi version requirements.  Part #" + (i + 1) + " \"" + parts[i] + "\" of an OSGi version must be a non-negative number (#.#.#.*).");
        }
        if (parts.length == 4) {
            for (char c : parts[3].toCharArray()) {
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '_') continue;
                throw new EnforcerRuleException("The OSGi qualifier of \"" + version + "\" does not conform to the OSGi version requirements.  Only Letters (upper and lower), numbers, dash '-', and underscore '_' are allowed.");
            }
        }
    }

    public String getCacheId() {
        return "osgi-version";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return true;
    }
}

