/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.enforcer.rules;

import java.io.IOException;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.FileUtils;

public class VersionTxtRule
implements EnforcerRule {
    private boolean shouldIfail = false;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            String versionTxt;
            String artifactId = (String)helper.evaluate("${project.artifactId}");
            String version = (String)helper.evaluate("${project.version}");
            if ("jetty-project".equals(artifactId) && !version.contains("SNAPSHOT") && (versionTxt = FileUtils.fileRead((String)"VERSION.txt")).contains("SNAPSHOT")) {
                this.shouldIfail = true;
            }
            if (this.shouldIfail) {
                throw new EnforcerRuleException("When version is a non-snapshot, VERSION.txt should not have a SNAPSHOT version in it.");
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Unable to read VERSION.txt - " + e.getLocalizedMessage(), (Exception)e);
        }
    }

    public String getCacheId() {
        return "" + this.shouldIfail;
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return true;
    }
}

