/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.IO;
import org.eclipse.jetty.toolchain.test.JAR;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.OS;
import org.eclipse.jetty.toolchain.test.PathAssert;
import org.eclipse.jetty.toolchain.test.TestingDir;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyDistro {
    private String artifactName = "jetty-distribution";
    private long startTime = 60L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private File jettyHomeDir;
    private Process pid;
    private URI baseUri;
    private String jmxUrl;
    private boolean _debug = false;

    public JettyDistro(Class<?> clazz) throws IOException {
        this(clazz, null);
    }

    public JettyDistro(Class<?> clazz, String artifact) throws IOException {
        this.jettyHomeDir = MavenTestingUtils.getTargetTestingDir(clazz, "jettyHome");
        if (artifact != null) {
            this.artifactName = artifact;
        }
        this.copyBaseDistro();
    }

    public JettyDistro(TestingDir testdir) throws IOException {
        this.jettyHomeDir = testdir.getDir();
        this.copyBaseDistro();
    }

    public JettyDistro(TestingDir testdir, String artifact) throws IOException {
        this.jettyHomeDir = testdir.getDir();
        if (artifact != null) {
            this.artifactName = artifact;
        }
        this.copyBaseDistro();
    }

    private void copyBaseDistro() throws IOException {
        File distroUnpackDir = MavenTestingUtils.getTargetFile("test-dist");
        PathAssert.assertDirExists(this.artifactName + " dependency:unpack", distroUnpackDir);
        File[] subdirs = distroUnpackDir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                if (!path.isDirectory()) {
                    return false;
                }
                return path.getName().startsWith(JettyDistro.this.artifactName + "-");
            }
        });
        if (subdirs.length == 0) {
            StringBuilder err = new StringBuilder();
            err.append("No target/test-dist/");
            err.append(this.artifactName);
            err.append("-${version} directory found.");
            err.append("\n  To fix this, run 'mvn process-test-resources' to create the directory.");
            throw new IOException(err.toString());
        }
        if (subdirs.length != 1) {
            StringBuilder err = new StringBuilder();
            err.append("Too many target/test-dist/");
            err.append(this.artifactName);
            err.append("-${version} directories found.");
            for (File dir : subdirs) {
                err.append("\n  ").append(dir.getAbsolutePath());
            }
            err.append("\n  To fix this, run 'mvn clean process-test-resources' to recreate the target/test-dist directory.");
            throw new IOException(err.toString());
        }
        File distroSrcDir = subdirs[0];
        FS.ensureEmpty(this.jettyHomeDir);
        System.out.printf("Copying Jetty Distribution: %s%n", distroSrcDir.getAbsolutePath());
        System.out.printf("            To Testing Dir: %s%n", this.jettyHomeDir.getAbsolutePath());
        IO.copyDir(distroSrcDir, this.jettyHomeDir);
    }

    public File getJettyHomeDir() {
        return this.jettyHomeDir;
    }

    public void copyTestWar(String testWarFilename) throws IOException {
        File srcWar = MavenTestingUtils.getTargetFile("test-wars/" + testWarFilename);
        File destWar = new File(this.jettyHomeDir, OS.separators("webapps/" + testWarFilename));
        FS.ensureDirExists(destWar.getParentFile());
        IO.copyFile(srcWar, destWar);
    }

    public void copyResource(String resourcePath, String outputPath) throws IOException {
        File srcFile = MavenTestingUtils.getTestResourceFile(resourcePath);
        File destFile = new File(this.jettyHomeDir, OS.separators(outputPath));
        FS.ensureDirExists(destFile.getParentFile());
        IO.copyFile(srcFile, destFile);
    }

    public void copyLib(String libFilename, String outputPath) throws IOException {
        File srcLib = MavenTestingUtils.getTargetFile("test-libs/" + libFilename);
        File destLib = new File(this.jettyHomeDir, OS.separators(outputPath));
        FS.ensureDirExists(destLib.getParentFile());
        IO.copyFile(srcLib, destLib);
    }

    public void copyProjectMainConfig() throws IOException {
        File srcDir = MavenTestingUtils.getProjectDir("src/main/config");
        IO.copyDir(srcDir, this.jettyHomeDir);
    }

    public void createProjectLib(String jarFilename) throws IOException {
        File srcDir = MavenTestingUtils.getTargetFile("classes");
        File libSelfDir = new File(this.jettyHomeDir, OS.separators("lib/self"));
        FS.ensureDirExists(libSelfDir);
        File jarFile = new File(libSelfDir, jarFilename);
        JAR.create(srcDir, jarFile);
    }

    public void unpackConfig(String configFilename) throws IOException {
        File srcConfig = MavenTestingUtils.getTargetFile("test-configs/" + configFilename);
        JAR.unpack(srcConfig, this.jettyHomeDir);
    }

    public void delete(String path) {
        File jettyPath = new File(this.jettyHomeDir, OS.separators(path));
        FS.delete(jettyPath);
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public void overlayConfig(String testConfigName) throws IOException {
        File srcDir = MavenTestingUtils.getTestResourceDir(testConfigName);
        IO.copyDir(srcDir, this.jettyHomeDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getJavaBin());
        commands.add("-Djetty.home=" + this.jettyHomeDir.getAbsolutePath());
        commands.add("-jar");
        commands.add("start.jar");
        commands.add("jetty.port=0");
        if (this._debug) {
            commands.add("-D.DEBUG=true");
        }
        commands.add("--dry-run");
        ProcessBuilder pbCmd = new ProcessBuilder(commands);
        pbCmd.directory(this.jettyHomeDir);
        String cmdLine = null;
        Process pidCmd = pbCmd.start();
        try {
            cmdLine = this.readOutputLine(pidCmd);
        }
        finally {
            pidCmd.destroy();
        }
        if (cmdLine == null || !cmdLine.contains("XmlConfiguration")) {
            Assert.fail((String)"Unable to get Jetty command line");
        }
        List<String> execCommands = JettyDistro.splitAndUnescapeCommandLine(cmdLine);
        System.out.printf("Executing: %s%n", cmdLine);
        System.out.printf("Working Dir: %s%n", this.jettyHomeDir.getAbsolutePath());
        pbCmd = new ProcessBuilder(execCommands);
        this.pid = pbCmd.start();
        ConsoleParser parser = new ConsoleParser();
        List<String[]> jmxList = parser.newPattern("JMX Remote URL: (.*)", 0);
        List<String[]> connList = parser.newPattern("Started [A-Za-z]*Connector@([0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*):([0-9]*)", 1);
        this.startPump("STDOUT", parser, this.pid.getInputStream());
        this.startPump("STDERR", parser, this.pid.getErrorStream());
        try {
            parser.waitForDone(this.startTime, this.timeUnit);
            if (!jmxList.isEmpty()) {
                this.jmxUrl = jmxList.get(0)[0];
                System.out.printf("## Found JMX connector at %s%n", this.jmxUrl);
            }
            if (!connList.isEmpty()) {
                String[] params = connList.get(0);
                if (params.length == 2) {
                    this.baseUri = URI.create("http://localhost:" + params[1] + "/");
                }
                System.out.printf("## Found Jetty connector at host: %s port: %s%n", params);
            }
        }
        catch (InterruptedException e) {
            this.pid.destroy();
            Assert.fail((String)"Unable to get required information within time limit");
        }
    }

    public static List<String> splitAndUnescapeCommandLine(CharSequence rawCmdLine) {
        ArrayList<String> cmds = new ArrayList<String>();
        int len = rawCmdLine.length();
        StringBuilder arg = new StringBuilder();
        boolean escaped = false;
        boolean inQuote = false;
        for (int i = 0; i < len; ++i) {
            char c = rawCmdLine.charAt(i);
            if (escaped) {
                switch (c) {
                    case 'r': {
                        arg.append('\r');
                        break;
                    }
                    case 'f': {
                        arg.append('\f');
                        break;
                    }
                    case 't': {
                        arg.append('\t');
                        break;
                    }
                    case 'n': {
                        arg.append('\n');
                        break;
                    }
                    case 'b': {
                        arg.append('\b');
                        break;
                    }
                    default: {
                        arg.append(c);
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ' ' && !inQuote) {
                cmds.add(String.valueOf(arg.toString()));
                arg.setLength(0);
                continue;
            }
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            arg.append(c);
        }
        cmds.add(String.valueOf(arg.toString()));
        return cmds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readOutputLine(Process pidCmd) throws IOException {
        String string;
        InputStream in = null;
        InputStreamReader reader = null;
        BufferedReader buf = null;
        try {
            in = pidCmd.getInputStream();
            reader = new InputStreamReader(in);
            buf = new BufferedReader(reader);
            string = buf.readLine();
        }
        catch (Throwable throwable) {
            IO.close(buf);
            IO.close(reader);
            IO.close(in);
            throw throwable;
        }
        IO.close(buf);
        IO.close(reader);
        IO.close(in);
        return string;
    }

    private void startPump(String mode, ConsoleParser parser, InputStream inputStream) {
        ConsoleStreamer pump = new ConsoleStreamer(mode, inputStream);
        pump.setParser(parser);
        Thread thread = new Thread((Runnable)pump, "ConsoleStreamer/" + mode);
        thread.start();
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    private String getJavaBin() {
        String[] javaexes = new String[]{"java", "java.exe"};
        File javaHomeDir = new File(System.getProperty("java.home"));
        for (String javaexe : javaexes) {
            File javabin = new File(javaHomeDir, OS.separators("bin/" + javaexe));
            if (!javabin.exists() || !javabin.isFile()) continue;
            return javabin.getAbsolutePath();
        }
        Assert.fail((String)"Unable to find java bin");
        return "java";
    }

    public void stop() {
        System.out.println("Stopping JettyDistro ...");
        if (this.pid != null) {
            this.pid.destroy();
        }
    }

    public void setStartTime(long startTime, TimeUnit timeUnit) {
        this.startTime = startTime;
        this.timeUnit = timeUnit;
    }

    private static class ConsoleStreamer
    implements Runnable {
        private String mode;
        private BufferedReader reader;
        private ConsoleParser parser;

        public ConsoleStreamer(String mode, InputStream is) {
            this.mode = mode;
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        public void setParser(ConsoleParser connector) {
            this.parser = connector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    if (this.parser != null) {
                        this.parser.parse(line);
                    }
                    System.out.println("[" + this.mode + "] " + line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IO.close(this.reader);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsolePattern {
        private Pattern pattern;
        private List<String[]> matches;
        private int count;

        ConsolePattern(String exp, int cnt) {
            this.pattern = Pattern.compile(exp);
            this.matches = new ArrayList<String[]>();
            this.count = cnt;
        }

        public Matcher getMatcher(String line) {
            return this.pattern.matcher(line);
        }

        public List<String[]> getMatches() {
            return this.matches;
        }

        public int getCount() {
            return this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsoleParser {
        private List<ConsolePattern> patterns = new ArrayList<ConsolePattern>();
        private CountDownLatch latch;
        private int count;

        private ConsoleParser() {
        }

        public List<String[]> newPattern(String exp, int cnt) {
            ConsolePattern pat = new ConsolePattern(exp, cnt);
            this.patterns.add(pat);
            this.count += cnt;
            return pat.getMatches();
        }

        public void parse(String line) {
            for (ConsolePattern pat : this.patterns) {
                Matcher mat = pat.getMatcher(line);
                if (!mat.find()) continue;
                int num = 0;
                int count = mat.groupCount();
                String[] match = new String[count];
                while (num++ < count) {
                    match[num - 1] = mat.group(num);
                }
                pat.getMatches().add(match);
                if (pat.getCount() <= 0) continue;
                this.getLatch().countDown();
            }
        }

        public void waitForDone(long timeout, TimeUnit unit) throws InterruptedException {
            this.getLatch().await(timeout, unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CountDownLatch getLatch() {
            ConsoleParser consoleParser = this;
            synchronized (consoleParser) {
                if (this.latch == null) {
                    this.latch = new CountDownLatch(this.count);
                }
            }
            return this.latch;
        }
    }
}

