/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import org.junit.Assert;

public final class PathAssert {
    private PathAssert() {
    }

    public static void assertDirExists(String msg, File path) {
        PathAssert.assertExists(msg, path);
        Assert.assertTrue((String)(msg + " path should be a Dir : " + path.getAbsolutePath()), (boolean)path.isDirectory());
    }

    public static void assertFileExists(String msg, File path) {
        PathAssert.assertExists(msg, path);
        Assert.assertTrue((String)(msg + " path should be a File : " + path.getAbsolutePath()), (boolean)path.isFile());
    }

    public static void assertExists(String msg, File path) {
        Assert.assertTrue((String)(msg + " path should exist: " + path.getAbsolutePath()), (boolean)path.exists());
    }

    public static void assertNotExists(String msg, File path) {
        Assert.assertFalse((String)(msg + " path should not exist: " + path.getAbsolutePath()), (boolean)path.exists());
    }
}

