/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test.http;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;

public class SimpleHttpParser {
    public SimpleHttpResponse readResponse(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            throw new EOFException();
        }
        Matcher responseLine = Pattern.compile("HTTP/1.1\\s+(\\d+)").matcher(line);
        Assert.assertThat((String)"http version is 1.1", (Object)responseLine.lookingAt(), (org.hamcrest.Matcher)CoreMatchers.is((Object)true));
        String code = responseLine.group(1);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        while ((line = reader.readLine()) != null && line.trim().length() != 0) {
            this.parseHeader(line, headers);
        }
        StringBuilder body = headers.containsKey("content-length") ? this.parseContentLengthDelimitedBody(reader, headers) : ("chunked".equals(headers.get("transfer-encoding")) ? this.parseChunkedBody(reader) : this.parseEOFDelimitedBody(reader, headers));
        return new SimpleHttpResponse(code, headers, body.toString().trim());
    }

    private void parseHeader(String line, Map<String, String> headers) {
        Matcher header = Pattern.compile("([^:]+):\\s*(.*)").matcher(line);
        Assert.assertTrue((boolean)header.lookingAt());
        String headerName = header.group(1);
        String headerValue = header.group(2);
        headers.put(headerName.toLowerCase(), headerValue.toLowerCase());
    }

    private StringBuilder parseContentLengthDelimitedBody(BufferedReader reader, Map<String, String> headers) throws IOException {
        int readLen = 0;
        int length = Integer.parseInt(headers.get("content-length"));
        StringBuilder body = new StringBuilder(length);
        try {
            for (int i = 0; i < length; ++i) {
                char c = (char)reader.read();
                body.append(c);
                ++readLen;
            }
        }
        catch (SocketTimeoutException e) {
            System.err.printf("Read %,d bytes (out of an expected %,d bytes)%n", readLen, length);
            throw e;
        }
        return body;
    }

    private StringBuilder parseChunkedBody(BufferedReader reader) throws IOException {
        String line;
        StringBuilder body = new StringBuilder(65536);
        while ((line = reader.readLine()) != null) {
            if ("0".equals(line)) {
                line = reader.readLine();
                Assert.assertThat((String)"There's no more content after as 0 indicated the final chunk", (Object)line, (org.hamcrest.Matcher)CoreMatchers.is((Object)""));
                break;
            }
            int length = Integer.parseInt(line, 16);
            for (int i = 0; i < length; ++i) {
                char c = (char)reader.read();
                body.append(c);
            }
            reader.readLine();
        }
        return body;
    }

    private StringBuilder parseEOFDelimitedBody(BufferedReader reader, Map<String, String> headers) throws IOException {
        int read;
        StringBuilder body = new StringBuilder();
        while ((read = reader.read()) != -1) {
            char c = (char)read;
            body.append(c);
        }
        return body;
    }
}

