/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test.jupiter;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.StringMangler;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class WorkDirExtension
implements BeforeEachCallback,
ParameterResolver {
    public void beforeEach(ExtensionContext context) throws IOException {
        if (!context.getTestInstance().isPresent()) {
            throw new RuntimeException("Unable to use @" + WorkDir.class.getSimpleName() + " on this type of test");
        }
        Object obj = context.getTestInstance().get();
        Path testPath = this.toPath(obj.getClass(), context);
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(WorkDir.class)) continue;
            try {
                field.set(obj, new WorkDir(testPath));
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }
    }

    private Path toPath(Class<?> classContext, ExtensionContext context) throws IOException {
        StringBuilder dirName = new StringBuilder();
        Class<?> clazz = context.getTestClass().orElse(classContext);
        dirName.append(StringMangler.condensePackageString(clazz.getName()));
        dirName.append(File.separatorChar);
        if (context.getTestMethod().isPresent()) {
            String methodname = ((Method)context.getTestMethod().get()).getName();
            if (OS.WINDOWS.isCurrentOs()) {
                dirName.append(StringMangler.maxStringLength(30, methodname));
            } else {
                dirName.append(methodname);
            }
            if (!context.getDisplayName().startsWith(methodname)) {
                dirName.append(URLEncoder.encode(context.getDisplayName().trim(), StandardCharsets.UTF_8.toString()));
            }
        } else {
            dirName.append(URLEncoder.encode(context.getDisplayName().trim(), StandardCharsets.UTF_8.toString()));
        }
        return MavenTestingUtils.getTargetTestingPath().resolve(dirName.toString());
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().isAssignableFrom(WorkDir.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            Path dir = this.toPath(parameterContext.getDeclaringExecutable().getDeclaringClass(), extensionContext);
            return new WorkDir(dir);
        }
        catch (IOException e) {
            throw new ParameterResolutionException("Unable to resolve work dir", (Throwable)e);
        }
    }
}

