/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.mapping;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBDocumentManager;
import org.eclipse.jnosql.databases.mongodb.mapping.MongoDBTemplate;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.semistructured.AbstractSemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;
import org.eclipse.jnosql.mapping.semistructured.EventPersistManager;

@ApplicationScoped
@Typed(value={MongoDBTemplate.class})
class DefaultMongoDBTemplate
extends AbstractSemiStructuredTemplate
implements MongoDBTemplate {
    private Instance<MongoDBDocumentManager> manager;
    private EntityConverter converter;
    private EntitiesMetadata entities;
    private Converters converters;
    private EventPersistManager persistManager;

    @Inject
    DefaultMongoDBTemplate(Instance<MongoDBDocumentManager> manager, EntityConverter converter, EntitiesMetadata entities, Converters converters, EventPersistManager persistManager) {
        this.manager = manager;
        this.converter = converter;
        this.entities = entities;
        this.converters = converters;
        this.persistManager = persistManager;
    }

    DefaultMongoDBTemplate() {
        this(null, null, null, null, null);
    }

    protected EntityConverter converter() {
        return this.converter;
    }

    protected MongoDBDocumentManager manager() {
        return (MongoDBDocumentManager)this.manager.get();
    }

    protected EventPersistManager eventManager() {
        return this.persistManager;
    }

    protected EntitiesMetadata entities() {
        return this.entities;
    }

    protected Converters converters() {
        return this.converters;
    }

    @Override
    public long delete(String collectionName, Bson filter) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(filter, "filter is required");
        return this.manager().delete(collectionName, filter);
    }

    @Override
    public <T> long delete(Class<T> entity, Bson filter) {
        Objects.requireNonNull(entity, "Entity is required");
        Objects.requireNonNull(filter, "filter is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        return this.manager().delete(entityMetadata.name(), filter);
    }

    @Override
    public <T> Stream<T> select(String collectionName, Bson filter) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(filter, "filter is required");
        Stream<CommunicationEntity> entityStream = this.manager().select(collectionName, filter);
        return entityStream.map(arg_0 -> ((EntityConverter)this.converter).toEntity(arg_0));
    }

    @Override
    public <T> Stream<T> select(Class<T> entity, Bson filter) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(filter, "filter is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        Stream<CommunicationEntity> entityStream = this.manager().select(entityMetadata.name(), filter);
        return entityStream.map(arg_0 -> ((EntityConverter)this.converter).toEntity(arg_0));
    }

    @Override
    public Stream<Map<String, BsonValue>> aggregate(String collectionName, Bson ... pipeline) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(pipeline, "pipeline is required");
        return this.manager().aggregate(collectionName, pipeline);
    }

    @Override
    public <T> Stream<Map<String, BsonValue>> aggregate(Class<T> entity, Bson ... pipeline) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(pipeline, "pipeline is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        return this.manager().aggregate(entityMetadata.name(), pipeline);
    }

    @Override
    public <T> Stream<T> aggregate(String collectionName, List<Bson> pipeline) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(pipeline, "pipeline is required");
        return this.manager().aggregate(collectionName, pipeline).map(arg_0 -> ((EntityConverter)this.converter).toEntity(arg_0));
    }

    @Override
    public <T> Stream<T> aggregate(Class<T> entity, List<Bson> pipeline) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(pipeline, "pipeline is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        return this.manager().aggregate(entityMetadata.name(), pipeline).map(arg_0 -> ((EntityConverter)this.converter).toEntity(arg_0));
    }

    @Override
    public long count(String collectionName, Bson filter) {
        Objects.requireNonNull(collectionName, "collection name is required");
        Objects.requireNonNull(filter, "filter is required");
        return this.manager().count(collectionName, filter);
    }

    @Override
    public <T> long count(Class<T> entity, Bson filter) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(filter, "filter is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        return this.manager().count(entityMetadata.name(), filter);
    }
}

