/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.jazz;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.lyo.client.exception.JazzAuthErrorException;
import org.eclipse.lyo.client.exception.JazzAuthFailedException;
import org.eclipse.lyo.client.oslc.OslcClient;

public class JazzFormAuthClient
extends OslcClient {
    private static Logger logger = Logger.getLogger(JazzFormAuthClient.class);
    private String url;
    private String authUrl;
    private String project;
    private String user;
    private String password;
    private HttpResponse lastRedirectResponse = null;
    private String jsaCsrfCookie = null;
    private static final String JAZZ_AUTH_MESSAGE_HEADER = "X-com-ibm-team-repository-web-auth-msg";
    private static final String JAZZ_AUTH_FAILED = "authfailed";
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String JAZZ_JSA_REDIRECT_HEADER = "X-JSA-AUTHORIZATION-REDIRECT";

    public JazzFormAuthClient() {
    }

    public JazzFormAuthClient(String url, String user, String password) {
        this();
        this.url = url;
        this.authUrl = url;
        this.user = user;
        this.password = password;
    }

    public JazzFormAuthClient(String url, String authUrl, String user, String password) {
        this(url, user, password);
        this.authUrl = authUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int login() throws JazzAuthFailedException, JazzAuthErrorException, ClientProtocolException, IOException {
        int statusCode = -1;
        String location = null;
        HttpGet authenticatedIdentity = new HttpGet(this.authUrl + "/authenticated/identity");
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)authenticatedIdentity);
        statusCode = resp.getStatusLine().getStatusCode();
        location = this.getHeader((HttpResponse)resp, "Location");
        EntityUtils.consume((HttpEntity)resp.getEntity());
        statusCode = this.followRedirects(statusCode, location);
        if (401 == statusCode && this.handleJsaServer().booleanValue()) {
            authenticatedIdentity = new HttpGet(this.lastRedirectResponse.getFirstHeader(JAZZ_JSA_REDIRECT_HEADER).getValue() + "&prompt=none");
            String credentials = new String(this.user + ":" + this.password);
            authenticatedIdentity.setHeader("Authorization", "Basic " + Base64.encode((byte[])credentials.getBytes("UTF-8")));
            resp = this.httpClient.execute((HttpUriRequest)authenticatedIdentity);
            statusCode = resp.getStatusLine().getStatusCode();
            EntityUtils.consume((HttpEntity)resp.getEntity());
            statusCode = this.followRedirects(statusCode, this.getHeader((HttpResponse)resp, "Location"));
        }
        HttpPost securityCheck = new HttpPost(this.authUrl + "/j_security_check");
        StringEntity entity = new StringEntity("j_username=" + this.user + "&j_password=" + this.password);
        securityCheck.setHeader("Accept", "*/*");
        securityCheck.setHeader("X-Requested-With", "XMLHttpRequest");
        securityCheck.setEntity((HttpEntity)entity);
        securityCheck.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        securityCheck.addHeader("OSLC-Core-Version", "2.0");
        securityCheck.addHeader("Cookie", this.jsaCsrfCookie);
        resp = this.httpClient.execute((HttpUriRequest)securityCheck);
        statusCode = resp.getStatusLine().getStatusCode();
        String jazzAuthMessage = null;
        Header jazzAuthMessageHeader = resp.getLastHeader(JAZZ_AUTH_MESSAGE_HEADER);
        if (jazzAuthMessageHeader != null) {
            jazzAuthMessage = jazzAuthMessageHeader.getValue();
        }
        if (jazzAuthMessage != null && jazzAuthMessage.equalsIgnoreCase(JAZZ_AUTH_FAILED)) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            throw new JazzAuthFailedException(this.user, this.url);
        }
        if (statusCode != 200 && statusCode != 302) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            throw new JazzAuthErrorException(statusCode, this.url);
        }
        location = this.getHeader((HttpResponse)resp, "Location");
        EntityUtils.consume((HttpEntity)resp.getEntity());
        statusCode = this.followRedirects(statusCode, location);
        return statusCode;
    }

    private Boolean handleJsaServer() throws ClientProtocolException, IOException, JazzAuthErrorException {
        if (null == this.lastRedirectResponse) {
            return false;
        }
        Header[] authHeaders = this.lastRedirectResponse.getHeaders(WWW_AUTHENTICATE_HEADER);
        if (2 > authHeaders.length) {
            return false;
        }
        Boolean basicChallenge = false;
        Boolean bearerChallenge = false;
        for (Header theHeader : authHeaders) {
            if (theHeader.getValue().contains("Basic")) {
                basicChallenge = true;
                continue;
            }
            if (!theHeader.getValue().contains("Bearer")) continue;
            bearerChallenge = true;
        }
        if (!basicChallenge.booleanValue() || !bearerChallenge.booleanValue()) {
            return false;
        }
        Header jsaRedirectHeader = this.lastRedirectResponse.getFirstHeader(JAZZ_JSA_REDIRECT_HEADER);
        if (null == jsaRedirectHeader) {
            return false;
        }
        return true;
    }

    @Deprecated
    public int formLogin() throws JazzAuthFailedException, JazzAuthErrorException {
        try {
            return this.login();
        }
        catch (JazzAuthFailedException jfe) {
            throw jfe;
        }
        catch (JazzAuthErrorException jee) {
            throw jee;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -1;
        }
    }

    private int followRedirects(int statusCode, String location) throws ClientProtocolException, IOException {
        while ((statusCode == 302 || 303 == statusCode) && location != null) {
            HttpGet get = new HttpGet(location);
            this.lastRedirectResponse = this.httpClient.execute((HttpUriRequest)get);
            statusCode = this.lastRedirectResponse.getStatusLine().getStatusCode();
            location = this.getHeader(this.lastRedirectResponse, "Location");
            EntityUtils.consume((HttpEntity)this.lastRedirectResponse.getEntity());
        }
        return statusCode;
    }

    private String getHeader(HttpResponse resp, String headerName) {
        String retval = null;
        Header header = resp.getFirstHeader(headerName);
        if (header != null) {
            retval = header.getValue();
        }
        return retval;
    }
}

