/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.jazz;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.InputStream;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;
import org.apache.wink.client.ClientResponse;
import org.eclipse.lyo.client.exception.ResourceNotFoundException;
import org.eclipse.lyo.client.exception.RootServicesException;
import org.eclipse.lyo.client.oslc.OslcClient;
import org.eclipse.lyo.client.oslc.OslcOAuthClient;
import org.eclipse.lyo.client.oslc.jazz.JazzFormAuthClient;

public class JazzRootServicesHelper {
    private String baseUrl;
    private String rootServicesUrl;
    private String catalogDomain;
    private String catalogNamespace;
    private String catalogProperty;
    private String catalogUrl;
    private Model rdfModel;
    String authorizationRealm;
    String requestTokenUrl;
    String authorizationTokenUrl;
    String accessTokenUrl;
    String requestConsumerKeyUrl;
    String consumerApprovalUrl;
    public static final String JFS_NAMESPACE = "http://jazz.net/xmlns/prod/jazz/jfs/1.0/";
    public static final String JD_NAMESPACE = "http://jazz.net/xmlns/prod/jazz/discovery/1.0/";
    private static final Logger logger = Logger.getLogger((String)JazzRootServicesHelper.class.getName());

    public JazzRootServicesHelper(String url, String catalogDomain) throws RootServicesException {
        this.baseUrl = url;
        this.rootServicesUrl = UriBuilder.fromUri((String)this.baseUrl).path("rootservices").build(new Object[0]).toString();
        logger.debug((Object)String.format("Fetching rootservices document at URL <%s>", this.rootServicesUrl));
        this.catalogDomain = catalogDomain;
        logger.debug((Object)String.format("Using catalog domain <%s>", this.catalogDomain));
        if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/cm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/cm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/cm/1.0/";
            this.catalogProperty = "cmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/qm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/qm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/qm/1.0/";
            this.catalogProperty = "qmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/rm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/rm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/rm/1.0/";
            this.catalogProperty = "rmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/am#")) {
            this.catalogNamespace = "http://open-services.net/ns/am#";
            this.catalogProperty = "amServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/auto#")) {
            this.catalogNamespace = "http://open-services.net/ns/auto#";
            this.catalogProperty = "autoServiceProviders";
        } else {
            logger.fatal((Object)"Jazz rootservices only supports CM, RM, QM, and Automation catalogs");
        }
        this.processRootServices();
    }

    public String getCatalogUrl() {
        return this.catalogUrl;
    }

    public OslcOAuthClient initOAuthClient(String consumerKey, String secret) {
        return new OslcOAuthClient(this.requestTokenUrl, this.authorizationTokenUrl, this.accessTokenUrl, consumerKey, secret, this.authorizationRealm);
    }

    public JazzFormAuthClient initFormClient(String userid, String password) {
        return new JazzFormAuthClient(this.baseUrl, userid, password);
    }

    public JazzFormAuthClient initFormClient(String userid, String password, String authUrl) {
        return new JazzFormAuthClient(this.baseUrl, authUrl, userid, password);
    }

    private void processRootServices() throws RootServicesException {
        try {
            OslcClient rootServicesClient = new OslcClient();
            ClientResponse response = rootServicesClient.getResource(this.rootServicesUrl, "application/rdf+xml");
            InputStream is = (InputStream)response.getEntity(InputStream.class);
            this.rdfModel = ModelFactory.createDefaultModel();
            this.rdfModel.read(is, this.rootServicesUrl);
            this.catalogUrl = this.getRootServicesProperty(this.rdfModel, this.catalogNamespace, this.catalogProperty);
            this.requestTokenUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthRequestTokenUrl");
            this.authorizationTokenUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthUserAuthorizationUrl");
            this.accessTokenUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthAccessTokenUrl");
            try {
                this.authorizationRealm = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthRealmName");
            }
            catch (ResourceNotFoundException e) {
                logger.debug((Object)String.format("OAuth authorization realm not found in rootservices <%s>", this.rootServicesUrl));
            }
            try {
                this.requestConsumerKeyUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthRequestConsumerKeyUrl");
            }
            catch (ResourceNotFoundException e) {
                logger.debug((Object)String.format("OAuth request consumer key URL not found in rootservices <%s>", this.rootServicesUrl));
            }
            try {
                this.consumerApprovalUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthApprovalModuleUrl");
            }
            catch (ResourceNotFoundException e) {
                logger.debug((Object)String.format("OAuth approval module URL not found in rootservices <%s>", this.rootServicesUrl));
            }
        }
        catch (Exception e) {
            throw new RootServicesException(this.baseUrl, e);
        }
    }

    private String getRootServicesProperty(Model rdfModel, String namespace, String predicate) throws ResourceNotFoundException {
        String returnVal = null;
        Property prop = rdfModel.createProperty(namespace, predicate);
        Statement stmt = rdfModel.getProperty((Resource)null, prop);
        if (stmt != null && stmt.getObject() != null) {
            returnVal = stmt.getObject().toString();
        }
        if (returnVal == null) {
            throw new ResourceNotFoundException(this.baseUrl, namespace + predicate);
        }
        return returnVal;
    }

    public Model getRdfModel() {
        return this.rdfModel;
    }

    public String getRequestConsumerKeyUrl() {
        return this.requestConsumerKeyUrl;
    }

    public String getConsumerApprovalUrl() {
        return this.consumerApprovalUrl;
    }
}

