/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lyo.client.oslc.resources.Property;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcResourceShape(title="Automation Plan Resource Shape", describes={"http://open-services.net/ns/auto#AutomationPlan"})
@OslcNamespace(value="http://open-services.net/ns/auto#")
public final class AutomationPlan
extends AbstractResource {
    private final Set<URI> contributors = new TreeSet<URI>();
    private final Set<URI> creators = new TreeSet<URI>();
    private final Set<URI> rdfTypes = new TreeSet<URI>();
    private final Set<String> subjects = new TreeSet<String>();
    private final Set<Property> parameterDefinitions = new TreeSet<Property>();
    private Date created;
    private String description;
    private String identifier;
    private URI instanceShape;
    private Date modified;
    private URI serviceProvider;
    private String title;

    public AutomationPlan() {
        this.rdfTypes.add(URI.create("http://open-services.net/ns/auto#AutomationPlan"));
    }

    public AutomationPlan(URI about) {
        super(about);
        this.rdfTypes.add(URI.create("http://open-services.net/ns/auto#AutomationPlan"));
    }

    protected URI getRdfType() {
        return URI.create("http://open-services.net/ns/auto#AutomationPlan");
    }

    public void addContributor(URI contributor) {
        this.contributors.add(contributor);
    }

    public void addCreator(URI creator) {
        this.creators.add(creator);
    }

    public void addRdfType(URI rdfType) {
        this.rdfTypes.add(rdfType);
    }

    public void addSubject(String subject) {
        this.subjects.add(subject);
    }

    public void addParameterDefinition(Property parameter) {
        this.parameterDefinitions.add(parameter);
    }

    @OslcDescription(value="The person(s) who are responsible for the work needed to complete the automation plan.")
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Contributors")
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    @OslcDescription(value="Timestamp of resource creation.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcReadOnly
    @OslcTitle(value="Created")
    public Date getCreated() {
        return this.created;
    }

    @OslcDescription(value="Creator or creators of resource.")
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Creators")
    public URI[] getCreators() {
        return this.creators.toArray(new URI[this.creators.size()]);
    }

    @OslcDescription(value="Descriptive text (reference: Dublin Core) about resource represented as rich text in XHTML content.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="A unique identifier for a resource. Assigned by the service provider when a resource is created. Not intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcReadOnly
    @OslcTitle(value="Identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @OslcDescription(value="Resource Shape that provides hints as to resource property value-types and allowed values. ")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcTitle(value="Instance Shape")
    public URI getInstanceShape() {
        return this.instanceShape;
    }

    @OslcDescription(value="Timestamp last latest resource modification.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcReadOnly
    @OslcTitle(value="Modified")
    public Date getModified() {
        return this.modified;
    }

    @OslcDescription(value="The resource type URIs.")
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcTitle(value="Types")
    public URI[] getRdfTypes() {
        return this.rdfTypes.toArray(new URI[this.rdfTypes.size()]);
    }

    @OslcDescription(value="The scope of a resource is a URI for the resource's OSLC Service Provider.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProvider"})
    @OslcTitle(value="Service Provider")
    public URI getServiceProvider() {
        return this.serviceProvider;
    }

    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcReadOnly(value=false)
    @OslcTitle(value="Subjects")
    public String[] getSubjects() {
        return this.subjects.toArray(new String[this.subjects.size()]);
    }

    @OslcDescription(value="Title (reference: Dublin Core) or often a single line summary of the resource represented as rich text in XHTML content.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    @OslcDescription(value="The parameter definitions for the automation plan.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcName(value="parameterDefinition")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#parameterDefinition")
    @OslcValueType(value=ValueType.LocalResource)
    @OslcTitle(value="Parameter Definitions")
    public Property[] getParameterDefinitions() {
        return this.parameterDefinitions.toArray(new Property[this.parameterDefinitions.size()]);
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreators(URI[] creators) {
        this.creators.clear();
        if (creators != null) {
            this.creators.addAll(Arrays.asList(creators));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setInstanceShape(URI instanceShape) {
        this.instanceShape = instanceShape;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setRdfTypes(URI[] rdfTypes) {
        this.rdfTypes.clear();
        if (rdfTypes != null) {
            this.rdfTypes.addAll(Arrays.asList(rdfTypes));
        }
    }

    public void setServiceProvider(URI serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void setSubjects(String[] subjects) {
        this.subjects.clear();
        if (subjects != null) {
            this.subjects.addAll(Arrays.asList(subjects));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setParameterDefinitions(Property[] parameterDefinitions) {
        this.parameterDefinitions.clear();
        if (parameterDefinitions != null) {
            this.parameterDefinitions.addAll(Arrays.asList(parameterDefinitions));
        }
    }
}

