/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.wink.client.ClientResponse;
import org.eclipse.lyo.client.oslc.resources.OslcQuery;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;

public class OslcQueryResult
implements Iterator<OslcQueryResult> {
    public static final Property DEFAULT_MEMBER_PROPERTY = RDFS.member;
    public static final String SELECT_ANY_MEMBER = "org.eclipse.lyo.client.oslc.query.selectAnyMember";
    private final OslcQuery query;
    private final ClientResponse response;
    private final int pageNumber;
    private Property memberProperty = DEFAULT_MEMBER_PROPERTY;
    private Model rdfModel;
    private Resource infoResource;
    private Resource membersResource;
    private String nextPageUrl = "";
    private boolean rdfInitialized = false;

    public OslcQueryResult(OslcQuery query, ClientResponse response) {
        this.query = query;
        this.response = response;
        this.pageNumber = 1;
    }

    private OslcQueryResult(OslcQueryResult prev) {
        this.query = new OslcQuery(prev);
        this.response = this.query.getResponse();
        this.membersResource = prev.membersResource;
        this.memberProperty = prev.memberProperty;
        this.pageNumber = prev.pageNumber + 1;
    }

    private synchronized void initializeRdf() {
        if (!this.rdfInitialized) {
            this.rdfInitialized = true;
            this.rdfModel = ModelFactory.createDefaultModel();
            this.rdfModel.read((InputStream)this.response.getEntity(InputStream.class), this.query.getCapabilityUrl());
            Property rdfType = this.rdfModel.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
            Property responseInfo = this.rdfModel.createProperty("http://open-services.net/ns/core#", "ResponseInfo");
            ResIterator iter = this.rdfModel.listResourcesWithProperty(rdfType, (RDFNode)responseInfo);
            this.infoResource = null;
            if (iter.hasNext()) {
                this.infoResource = (Resource)iter.next();
            }
            this.membersResource = this.rdfModel.getResource(this.query.getCapabilityUrl());
        }
    }

    String getNextPageUrl() {
        this.initializeRdf();
        if ((this.nextPageUrl == null || this.nextPageUrl.isEmpty()) && this.infoResource != null) {
            Property predicate = this.rdfModel.getProperty("http://open-services.net/ns/core#", "nextPage");
            SimpleSelector select = new SimpleSelector(this.infoResource, predicate, (RDFNode)null);
            StmtIterator iter = this.rdfModel.listStatements((Selector)select);
            if (iter.hasNext()) {
                Statement nextPage = (Statement)iter.next();
                this.nextPageUrl = nextPage.getResource().getURI();
            } else {
                this.nextPageUrl = "";
            }
        }
        return this.nextPageUrl;
    }

    @Override
    public boolean hasNext() {
        return !"".equals(this.getNextPageUrl());
    }

    @Override
    public OslcQueryResult next() {
        return new OslcQueryResult(this);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public OslcQuery getQuery() {
        return this.query;
    }

    public String getMemberProperty() {
        return this.memberProperty.getURI();
    }

    public void setMemberProperty(String memberPredicate) {
        this.memberProperty = ModelFactory.createDefaultModel().createProperty(memberPredicate);
    }

    public ClientResponse getRawResponse() {
        return this.response;
    }

    private Selector getMemberSelector() {
        if ("true".equalsIgnoreCase(System.getProperty(SELECT_ANY_MEMBER))) {
            return new AnyMemberSelector(this.membersResource);
        }
        return new SimpleSelector(this.membersResource, this.memberProperty, (RDFNode)null);
    }

    public String[] getMembersUrls() {
        this.initializeRdf();
        ArrayList<String> membersUrls = new ArrayList<String>();
        Selector select = this.getMemberSelector();
        StmtIterator iter = this.rdfModel.listStatements(select);
        while (iter.hasNext()) {
            Statement member = (Statement)iter.next();
            membersUrls.add(member.getResource().getURI());
        }
        return membersUrls.toArray(new String[membersUrls.size()]);
    }

    public <T> Iterable<T> getMembers(final Class<T> clazz) {
        this.initializeRdf();
        Selector select = this.getMemberSelector();
        final StmtIterator iter = this.rdfModel.listStatements(select);
        Iterable result = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public T next() {
                        Statement member = (Statement)iter.next();
                        try {
                            return JenaModelHelper.fromJenaResource((Resource)((Resource)member.getObject()), (Class)clazz);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        catch (SecurityException e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        catch (DatatypeConfigurationException e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        catch (InstantiationException e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        catch (InvocationTargetException e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        catch (OslcCoreApplicationException e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        catch (NoSuchMethodException e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }
        };
        return result;
    }

    private final class AnyMemberSelector
    extends SimpleSelector {
        private AnyMemberSelector(Resource subject) {
            super(subject, null, (RDFNode)null);
        }

        public boolean selects(Statement s) {
            String fqPredicateName = s.getPredicate().getNameSpace() + s.getPredicate().getLocalName();
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(fqPredicateName)) {
                return false;
            }
            return s.getObject().isResource();
        }
    }
}

