/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcResourceShape(title="Parameter Instance Resource Shape", describes={"http://open-services.net/ns/auto#ParameterInstance"})
@OslcNamespace(value="http://open-services.net/ns/auto#")
public final class ParameterInstance
extends AbstractResource
implements Comparable<ParameterInstance> {
    private final Set<URI> rdfTypes = new TreeSet<URI>();
    private String name;
    private String value;
    private String description;
    private URI instanceShape;
    private URI serviceProvider;

    public ParameterInstance() {
        this.rdfTypes.add(URI.create("http://open-services.net/ns/auto#ParameterInstance"));
    }

    public ParameterInstance(URI about) {
        super(about);
        this.rdfTypes.add(URI.create("http://open-services.net/ns/auto#ParameterInstance"));
    }

    protected URI getRdfType() {
        return URI.create("http://open-services.net/ns/auto#ParameterInstance");
    }

    public void addRdfType(URI rdfType) {
        this.rdfTypes.add(rdfType);
    }

    @OslcDescription(value="Descriptive text (reference: Dublin Core) about resource represented as rich text in XHTML content.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="The name of the parameter instance.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#name")
    @OslcTitle(value="Name")
    public String getName() {
        return this.name;
    }

    @OslcDescription(value="The value of the parameter.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#value")
    @OslcTitle(value="Value")
    public String getValue() {
        return this.value;
    }

    @OslcDescription(value="Resource Shape that provides hints as to resource property value-types and allowed values. ")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcTitle(value="Instance Shape")
    public URI getInstanceShape() {
        return this.instanceShape;
    }

    @OslcDescription(value="The resource type URIs.")
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcTitle(value="Types")
    public URI[] getRdfTypes() {
        return this.rdfTypes.toArray(new URI[this.rdfTypes.size()]);
    }

    @OslcDescription(value="The scope of a resource is a URI for the resource's OSLC Service Provider.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProvider"})
    @OslcTitle(value="Service Provider")
    public URI getServiceProvider() {
        return this.serviceProvider;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setInstanceShape(URI instanceShape) {
        this.instanceShape = instanceShape;
    }

    public void setRdfTypes(URI[] rdfTypes) {
        this.rdfTypes.clear();
        if (rdfTypes != null) {
            this.rdfTypes.addAll(Arrays.asList(rdfTypes));
        }
    }

    public void setServiceProvider(URI serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    @Override
    public int compareTo(ParameterInstance o) {
        return o.getName().compareTo(this.name);
    }
}

