/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.pack200;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.codehaus.plexus.util.IOUtil;

public class EclipseInf {
    public static final String PATH_ECLIPSEINF = "META-INF/eclipse.inf";
    public static final String TRUE = "true";
    public static final String PACK200_CONDITIONED = "pack200.conditioned";
    private final Properties properties;

    private EclipseInf(Properties properties) {
        this.properties = properties;
    }

    public boolean shouldPack() {
        return !Boolean.parseBoolean(this.properties.getProperty("jarprocessor.exclude")) && !Boolean.parseBoolean(this.properties.getProperty("jarprocessor.exclude.pack"));
    }

    public boolean shouldSign() {
        return !Boolean.parseBoolean(this.properties.getProperty("jarprocessor.exclude")) && !Boolean.parseBoolean(this.properties.getProperty("jarprocessor.exclude.sign"));
    }

    public boolean isPackNormalized() {
        return Boolean.parseBoolean(this.properties.getProperty(PACK200_CONDITIONED));
    }

    public void setPackNormalized() {
        this.properties.put(PACK200_CONDITIONED, TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EclipseInf readEclipseInf(JarFile jarFile) throws IOException {
        Properties properties = new Properties();
        ZipEntry entry = jarFile.getEntry(PATH_ECLIPSEINF);
        if (entry != null) {
            InputStream is = jarFile.getInputStream(entry);
            try {
                properties.load(is);
            }
            finally {
                IOUtil.close((InputStream)is);
            }
            return new EclipseInf(properties);
        }
        return null;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        this.properties.store(buf, null);
        return buf.toByteArray();
    }
}

