/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.pack200;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.tycho.extras.pack200.EclipseInf;
import org.eclipse.tycho.extras.pack200.ForkedPack200Wrapper;
import org.eclipse.tycho.extras.pack200.Pack200Wrapper;

@Component(role=Pack200Archiver.class)
public class Pack200Archiver {
    @Requirement
    private Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean normalize(List<Artifact> pluginArtifacts, File file, File packFile) throws IOException {
        block15: {
            JarFile jarFile = new JarFile(file);
            try {
                EclipseInf eclipseInf = EclipseInf.readEclipseInf(jarFile);
                this.assertSupportedEclipseInf(eclipseInf);
                if (eclipseInf != null && (!eclipseInf.shouldPack() || eclipseInf.isPackNormalized())) break block15;
                if (this.isSigned(jarFile)) {
                    throw new IOException("pack200:normalize cannot be called for signed jar " + file);
                }
                this.log.info("Pack200 normalizing jar " + file.getAbsolutePath());
                File tmpFile = null;
                if (eclipseInf != null) {
                    eclipseInf.setPackNormalized();
                    tmpFile = File.createTempFile(file.getName(), ".prepack");
                    this.updateEclipseInf(jarFile, eclipseInf, tmpFile);
                }
                try {
                    this.getPack200().pack(pluginArtifacts, tmpFile != null ? tmpFile : file, packFile);
                }
                finally {
                    if (tmpFile != null && !tmpFile.delete()) {
                        throw new IOException("Could not delete temporary file " + tmpFile.getAbsolutePath());
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    protected void assertSupportedEclipseInf(EclipseInf eclipseInf) throws IOException {
        if (eclipseInf != null && eclipseInf.shouldPack() && eclipseInf.shouldSign()) {
            throw new IOException("Pack200 and jar signing cannot be both enabled in META-INF/eclipse.inf. See bug 388629.");
        }
    }

    private Pack200Wrapper getPack200() {
        try {
            Class.forName("java.nio.file.FileSystem");
            return new Pack200Wrapper();
        }
        catch (ClassNotFoundException mustBeJava6orEarlier) {
            return new ForkedPack200Wrapper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEclipseInf(JarFile jarFile, EclipseInf eclipseInf, File tmpFile) throws IOException {
        JarOutputStream jos = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
        try {
            JarEntry entry;
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.getName().equals("META-INF/eclipse.inf")) continue;
                this.copyJarEntry(jarFile, entry, jos);
            }
            entry = new JarEntry("META-INF/eclipse.inf");
            jos.putNextEntry(entry);
            jos.write(eclipseInf.toByteArray());
            jos.closeEntry();
        }
        finally {
            IOUtil.close((OutputStream)jos);
        }
    }

    private boolean isSigned(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF/") || !name.endsWith(".SF")) continue;
            return true;
        }
        return false;
    }

    private void copyJarEntry(JarFile jarFile, JarEntry entry, JarOutputStream jos) throws IOException {
        int n;
        jos.putNextEntry(entry);
        InputStream is = jarFile.getInputStream(entry);
        byte[] buf = new byte[4096];
        while ((n = is.read(buf)) != -1) {
            jos.write(buf, 0, n);
        }
        jos.closeEntry();
    }

    public void unpack(List<Artifact> pluginArtifacts, File packFile, File jarFile) throws IOException {
        this.getPack200().unpack(pluginArtifacts, packFile, jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pack(List<Artifact> pluginArtifacts, File file, File packFile) throws IOException {
        JarFile jarFile = new JarFile(file);
        try {
            EclipseInf eclipseInf = EclipseInf.readEclipseInf(jarFile);
            this.assertSupportedEclipseInf(eclipseInf);
            if (eclipseInf == null || eclipseInf.shouldPack() && eclipseInf.isPackNormalized()) {
                this.log.info("Pack200 packing jar " + file.getAbsolutePath());
                this.getPack200().pack(pluginArtifacts, file, packFile);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException e) {}
        }
        return false;
    }
}

