/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.pack200;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.artifact.Artifact;

public class Pack200Wrapper {
    public static final String COMMAND_PACK = "pack";
    public static final String COMMAND_UNPACK = "unpack";

    public void pack(List<Artifact> pluginArtifacts, File jar, File pack) throws IOException {
        this.pack(jar, pack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pack(File jar, File pack) throws IOException, FileNotFoundException {
        JarFile is = new JarFile(jar);
        try {
            GZIPOutputStream os = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(pack)));
            try {
                Pack200.Packer packer = this.newPacker();
                packer.pack(is, (OutputStream)os);
            }
            finally {
                Pack200Wrapper.close(os);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    private static void close(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void unpack(List<Artifact> pluginArtifacts, File packFile, File jarFile) throws IOException {
        this.unpack(packFile, jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unpack(File packFile, File jarFile) throws IOException, FileNotFoundException {
        GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(new FileInputStream(packFile)));
        try {
            JarOutputStream os = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));
            try {
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                unpacker.unpack((InputStream)is, os);
            }
            finally {
                Pack200Wrapper.close(os);
            }
        }
        finally {
            Pack200Wrapper.close(is);
        }
    }

    private Pack200.Packer newPacker() {
        Pack200.Packer packer = Pack200.newPacker();
        packer.properties().put("pack.segment.limit", "-1");
        return packer;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Syntax: " + Pack200Wrapper.class.getSimpleName() + " pack|unpack fileFrom fileTo");
            System.exit(-1);
        }
        File fileFrom = new File(args[1]).getCanonicalFile();
        File fileTo = new File(args[2]).getCanonicalFile();
        if (COMMAND_PACK.equals(args[0])) {
            new Pack200Wrapper().pack(fileFrom, fileTo);
            System.exit(0);
        } else if (COMMAND_UNPACK.equals(args[0])) {
            new Pack200Wrapper().unpack(fileFrom, fileTo);
            System.exit(0);
        }
        System.err.println("Unknown/unsupported command " + args[0]);
        System.exit(-1);
    }
}

