/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.p2maven.transport.MavenAuthenticator;

class RemoteMetadataRepositoryManager
implements IMetadataRepositoryManager {
    private final IMetadataRepositoryManager delegate;
    private final IRepositoryIdManager loadingHelper;
    private final Logger logger;
    private MavenAuthenticator authenticator;

    RemoteMetadataRepositoryManager(IMetadataRepositoryManager delegate, IRepositoryIdManager loadingHelper, Logger logger, MavenAuthenticator authenticator) {
        this.delegate = delegate;
        this.authenticator = authenticator;
        this.loadingHelper = Objects.requireNonNull(loadingHelper);
        this.logger = logger;
    }

    private URI translate(URI location) {
        return this.loadingHelper.getEffectiveLocation(location);
    }

    private URI translateAndPrepareLoad(URI location) throws ProvisionException {
        return this.loadingHelper.getEffectiveLocationAndPrepareLoad(location);
    }

    public IMetadataRepository loadRepository(URI location, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        return this.loadRepository(location, 0, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetadataRepository loadRepository(URI location, int flags, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        URI effectiveLocation = this.translateAndPrepareLoad(location);
        this.authenticator.enterLoad(location);
        try {
            IMetadataRepository loadedRepository = this.delegate.loadRepository(effectiveLocation, flags, monitor);
            this.failIfRepositoryContainsPartialIUs(loadedRepository, effectiveLocation);
            IMetadataRepository iMetadataRepository = loadedRepository;
            return iMetadataRepository;
        }
        finally {
            this.authenticator.exitLoad();
        }
    }

    private void failIfRepositoryContainsPartialIUs(IMetadataRepository repository, URI effectiveLocation) throws ProvisionException {
        IQueryResult allUnits = repository.query(QueryUtil.ALL_UNITS, null);
        boolean hasPartialIUs = false;
        for (IInstallableUnit unit : allUnits.toUnmodifiableSet()) {
            if (!Boolean.valueOf(unit.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) continue;
            hasPartialIUs = true;
            this.logger.error("Partial IU: " + unit.getId());
        }
        if (hasPartialIUs) {
            String message = "The p2 repository at " + String.valueOf(effectiveLocation) + " contains partial IUs (see above) from an old style update site which cannot be used for dependency resolution";
            throw new ProvisionException(message);
        }
    }

    public void addRepository(URI location) {
        this.delegate.addRepository(this.translate(location));
    }

    public boolean contains(URI location) {
        return this.delegate.contains(this.translate(location));
    }

    public IMetadataRepository createRepository(URI location, String name, String type, Map<String, String> properties) throws ProvisionException, OperationCanceledException {
        return this.delegate.createRepository(this.translate(location), name, type, properties);
    }

    public IProvisioningAgent getAgent() {
        return this.delegate.getAgent();
    }

    public URI[] getKnownRepositories(int flags) {
        return this.delegate.getKnownRepositories(flags);
    }

    public String getRepositoryProperty(URI location, String key) {
        return this.delegate.getRepositoryProperty(this.translate(location), key);
    }

    public boolean isEnabled(URI location) {
        return this.delegate.isEnabled(this.translate(location));
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return this.delegate.query(query, monitor);
    }

    public IMetadataRepository refreshRepository(URI location, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        return this.delegate.refreshRepository(this.translateAndPrepareLoad(location), monitor);
    }

    public boolean removeRepository(URI location) {
        return this.delegate.removeRepository(this.translate(location));
    }

    public void setEnabled(URI location, boolean enablement) {
        this.delegate.setEnabled(this.translate(location), enablement);
    }

    public void setRepositoryProperty(URI location, String key, String value) {
        this.delegate.setRepositoryProperty(this.translate(location), key, value);
    }
}

