/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.mojos;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.lib.manifest.ManifestUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.bnd.MavenProjectJar;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.bnd.BndPluginManager;
import org.eclipse.tycho.core.osgitools.BundleClassPath;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.helper.PluginRealmHelper;

@Mojo(name="process", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateManifestMojo
extends AbstractMojo {
    private static final Predicate<Path> CLASS_FILTER = resource -> {
        if (Files.isRegularFile(resource, new LinkOption[0])) {
            return resource.getFileName().toString().toLowerCase().endsWith(".class");
        }
        return true;
    };
    @Component
    private BndPluginManager bndPluginManager;
    @Parameter(property="project", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(property="session", readonly=true)
    protected MavenSession session;
    @Component
    private PluginRealmHelper pluginRealmHelper;
    @Component
    private TychoProjectManager projectManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TychoProject tychoProject = this.projectManager.getTychoProject(this.mavenProject).orElse(null);
        if (tychoProject instanceof OsgiBundleProject) {
            OsgiBundleProject osgi = (OsgiBundleProject)tychoProject;
            File basedir = this.mavenProject.getBasedir();
            File instructionsFile = new File(basedir, "pde.bnd");
            if (instructionsFile.isFile()) {
                Log log = this.getLog();
                log.debug((CharSequence)("Generate final manifest for project " + this.mavenProject.getId()));
                try (Project project = new Project(this.getWorkspace(), basedir, instructionsFile);
                     AutomaticManifestProjectBuilder builder = new AutomaticManifestProjectBuilder(project);
                     MavenProjectJar jar = new MavenProjectJar(this.mavenProject, CLASS_FILTER, log);){
                    this.setupProject(project);
                    BundleClassPath bundleClassPath = osgi.getBundleClassPath(DefaultReactorProject.adapt((MavenProject)this.mavenProject));
                    builder.setBase(project.getBase());
                    builder.setJar(jar);
                    for (ClasspathEntry cpe : bundleClassPath.getClasspathEntries()) {
                        cpe.getLocations().forEach(cp -> {
                            log.debug((CharSequence)("Adding classpath " + String.valueOf(cp)));
                            try {
                                project.addClasspath(cp);
                            }
                            catch (RuntimeException e) {
                                this.getLog().warn((CharSequence)("Adding classpath file " + String.valueOf(cp) + " failed: " + String.valueOf(e)));
                            }
                        });
                    }
                    try {
                        this.pluginRealmHelper.visitPluginExtensions(this.mavenProject, this.session, ClasspathContributor.class, cpc -> {
                            List list = cpc.getAdditionalClasspathEntries(this.mavenProject, "compile");
                            if (list != null && !list.isEmpty()) {
                                log.debug((CharSequence)("Adding additional classpath entries from contributor " + cpc.getClass().getSimpleName()));
                                for (ClasspathEntry entry : list) {
                                    List locations = entry.getLocations();
                                    for (File file : locations) {
                                        try {
                                            log.debug((CharSequence)(" --> " + String.valueOf(file)));
                                            builder.addClasspath(file);
                                        }
                                        catch (Exception e) {
                                            log.warn((CharSequence)("Adding additional classpath file " + String.valueOf(file) + " failed: " + String.valueOf(e)));
                                        }
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("can't call classpath contributors", e);
                    }
                    builder.build();
                    builder.getWarnings().forEach(arg_0 -> ((Log)log).warn(arg_0));
                    builder.getErrors().forEach(arg_0 -> ((Log)log).error(arg_0));
                    Manifest manifest = jar.getManifest();
                    if (manifest == null) {
                        log.debug((CharSequence)"No Manifest was generated!");
                    } else if (log.isDebugEnabled()) {
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        ManifestUtil.write((Manifest)manifest, (OutputStream)outputStream);
                        String str = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                        log.debug((CharSequence)("Generated final manifest for " + this.mavenProject.getId() + ":\r\n" + str));
                    }
                }
                catch (MojoExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MojoFailureException("Can't generate manifest data", (Throwable)e);
                }
            }
        }
    }

    void setupProject(Project bnd) throws Exception {
        bnd.setBase(this.mavenProject.getBasedir());
        bnd.setProperty("src", this.mavenProject.getCompileSourceRoots().stream().collect(Collectors.joining(",")));
        bnd.setProperty("bin", this.mavenProject.getBuild().getOutputDirectory());
        bnd.setProperty("target-dir", this.mavenProject.getBuild().getDirectory());
    }

    Workspace getWorkspace() throws Exception {
        Processor run = new Processor();
        run.setProperty("-standalone", "true");
        Workspace workspace = Workspace.createStandaloneWorkspace((Processor)run, (URI)new File(this.mavenProject.getBuild().getDirectory(), "cnf").toURI());
        this.bndPluginManager.setupWorkspace(workspace);
        return workspace;
    }

    private final class AutomaticManifestProjectBuilder
    extends ProjectBuilder {
        private AutomaticManifestProjectBuilder(Project project) {
            super(project);
        }

        public Jar getJarFromName(String name, String from) {
            Matcher m = TychoConstants.PLATFORM_URL_PATTERN.matcher(name);
            if (m.matches()) {
                TargetPlatform targetPlatform = GenerateManifestMojo.this.projectManager.getTargetPlatform(GenerateManifestMojo.this.mavenProject).orElse(null);
                if (targetPlatform == null) {
                    return null;
                }
                String pluginId = m.group(2);
                try {
                    ArtifactKey artifact = targetPlatform.resolveArtifact("eclipse-plugin", pluginId, null);
                    File artifactLocation = targetPlatform.getArtifactLocation(artifact);
                    if (artifactLocation == null) {
                        return null;
                    }
                    return new Jar(artifactLocation);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return super.getJarFromName(name, from);
        }
    }
}

