/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bndlib.source;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.tycho.bndlib.source.FieldVisitor;
import org.eclipse.tycho.bndlib.source.SourceCodeResolver;

public class SourceFile {
    public static final String JAVA_EXTENSION = ".java";
    private CompilationUnit compilationUnit;
    private SourceCodeResolver sourceCodeResolver;

    public SourceFile(CompilationUnit compilationUnit, SourceCodeResolver sourceCodeResolver) {
        this.compilationUnit = compilationUnit;
        this.sourceCodeResolver = sourceCodeResolver;
    }

    public PackageDeclaration getPackage() {
        return this.compilationUnit.getPackage();
    }

    public List<ImportDeclaration> getImports() {
        return this.compilationUnit.imports();
    }

    public boolean isType(String annotationFqdn, String annotationVersion) {
        return SourceFile.isType(annotationFqdn, annotationVersion, this.getImports());
    }

    public SourceFile findType(String clazz) {
        String typeName = SourceFile.getTypeName(clazz, this.getPackage().getName().getFullyQualifiedName(), this.getImports());
        return this.sourceCodeResolver.getCompilationUnit(typeName);
    }

    public String resolve(Expression expression) {
        if (expression instanceof StringLiteral) {
            StringLiteral literal = (StringLiteral)expression;
            return literal.getLiteralValue();
        }
        if (expression instanceof InfixExpression) {
            InfixExpression infix = (InfixExpression)expression;
            Expression leftOperand = infix.getLeftOperand();
            Expression rightOperand = infix.getRightOperand();
            InfixExpression.Operator operator = infix.getOperator();
            if (InfixExpression.Operator.PLUS.equals(operator)) {
                return this.resolve(leftOperand) + this.resolve(rightOperand);
            }
        }
        if (expression instanceof QualifiedName) {
            QualifiedName qualified = (QualifiedName)expression;
            String clazz = qualified.getQualifier().getFullyQualifiedName();
            String constant = qualified.getName().getFullyQualifiedName();
            SourceFile type = this.findType(clazz);
            if (type != null) {
                return type.getConstantValue(constant);
            }
        }
        if (expression instanceof SimpleName) {
            SimpleName simple = (SimpleName)expression;
            String name = simple.getFullyQualifiedName();
            for (ImportDeclaration imp : this.getImports()) {
                SourceFile type;
                String suffix;
                String fqdn;
                if (!imp.isStatic() || !(fqdn = imp.getName().getFullyQualifiedName()).endsWith(suffix = "." + name) || (type = this.findType(fqdn.substring(0, fqdn.length() - suffix.length()))) == null) continue;
                return type.getConstantValue(name);
            }
        }
        return "";
    }

    private String getConstantValue(String fieldName) {
        FieldVisitor visitor = new FieldVisitor(fieldName);
        this.compilationUnit.accept((ASTVisitor)visitor);
        return this.resolve(visitor.getInitializerExpression());
    }

    private static String getTypeName(String simpleOrFqdn, String pkg, List<ImportDeclaration> imports) {
        if (simpleOrFqdn.contains(".")) {
            return simpleOrFqdn;
        }
        for (ImportDeclaration importDecl : imports) {
            String name = importDecl.getName().getFullyQualifiedName();
            if (!name.endsWith("." + simpleOrFqdn)) continue;
            return name;
        }
        return pkg + "." + simpleOrFqdn;
    }

    private static boolean isType(String simpleOrFqdn, String type, List<ImportDeclaration> imports) {
        if (type.equals(simpleOrFqdn)) {
            return true;
        }
        if (type.endsWith("." + simpleOrFqdn)) {
            for (ImportDeclaration importDecl : imports) {
                if (!type.equals(importDecl.getName().getFullyQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }
}

