/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ActionListenerImplementations {
    static final ActionListener NOOP = new ActionListener(){

        public void onResponse(Object o) {
        }

        @Override
        public void onFailure(Exception e) {
        }

        public String toString() {
            return "NoopActionListener";
        }
    };

    private ActionListenerImplementations() {
    }

    static Runnable runnableFromReleasable(final Releasable releasable) {
        return new Runnable(){

            @Override
            public void run() {
                Releasables.closeExpectNoException((Releasable)releasable);
            }

            public String toString() {
                return "release[" + releasable + "]";
            }
        };
    }

    static void safeAcceptException(Consumer<Exception> consumer, Exception e) {
        assert (e != null);
        try {
            consumer.accept(e);
        }
        catch (RuntimeException ex) {
            if (e != null && ex != e) {
                ex.addSuppressed(e);
            }
            ActionListenerImplementations.expectNoException(ex);
        }
    }

    static void safeOnFailure(ActionListener<?> listener, Exception e) {
        ActionListenerImplementations.safeAcceptException(listener::onFailure, e);
    }

    private static void expectNoException(RuntimeException e) {
        assert (false) : e;
        throw e;
    }

    private static <Response, MappedResponse> MappedResponse applyExpectNoExceptions(Function<Response, MappedResponse> fn, Response innerResult) {
        try {
            return fn.apply(innerResult);
        }
        catch (RuntimeException e) {
            assert (false) : e;
            throw e;
        }
    }

    static final class NotifyOnceActionListener<Response>
    extends AtomicReference<ActionListener<Response>>
    implements ActionListener<Response> {
        NotifyOnceActionListener(ActionListener<Response> delegate) {
            super(delegate);
        }

        @Override
        public void onResponse(Response response) {
            ActionListener acquired = this.getAndSet(null);
            if (acquired != null) {
                acquired.onResponse(response);
            }
        }

        @Override
        public void onFailure(Exception e) {
            ActionListener acquired = this.getAndSet(null);
            if (acquired != null) {
                ActionListenerImplementations.safeOnFailure(acquired, e);
            }
        }

        @Override
        public String toString() {
            return "notifyOnce[" + this.get() + "]";
        }
    }

    static final class RunBeforeActionListener<T>
    extends DelegatingActionListener<T, T> {
        private final CheckedRunnable<?> runBefore;

        RunBeforeActionListener(ActionListener<T> delegate, CheckedRunnable<?> runBefore) {
            super(delegate);
            this.runBefore = runBefore;
        }

        @Override
        public void onResponse(T response) {
            try {
                this.runBefore.run();
            }
            catch (Exception ex) {
                super.onFailure(ex);
                return;
            }
            this.delegate.onResponse(response);
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.runBefore.run();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            super.onFailure(e);
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.runBefore;
        }
    }

    static final class RunAfterActionListener<T>
    extends DelegatingActionListener<T, T> {
        private final Runnable runAfter;

        RunAfterActionListener(ActionListener<T> delegate, Runnable runAfter) {
            super(delegate);
            this.runAfter = runAfter;
        }

        @Override
        public void onResponse(T response) {
            try {
                this.delegate.onResponse(response);
            }
            finally {
                this.runAfter.run();
            }
        }

        @Override
        public void onFailure(Exception e) {
            try {
                super.onFailure(e);
            }
            finally {
                this.runAfter.run();
            }
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.runAfter;
        }
    }

    static final class ResponseDroppingActionListener<T, R>
    extends DelegatingActionListener<T, R> {
        private final CheckedConsumer<ActionListener<R>, ? extends Exception> consumer;

        ResponseDroppingActionListener(ActionListener<R> delegate, CheckedConsumer<ActionListener<R>, ? extends Exception> consumer) {
            super(delegate);
            this.consumer = consumer;
        }

        @Override
        public void onResponse(T ignored) {
            try {
                this.consumer.accept((Object)this.delegate);
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.consumer;
        }
    }

    static final class ResponseWrappingActionListener<T, R>
    extends DelegatingActionListener<T, R> {
        private final CheckedBiConsumer<ActionListener<R>, T, ? extends Exception> bc;

        ResponseWrappingActionListener(ActionListener<R> delegate, CheckedBiConsumer<ActionListener<R>, T, ? extends Exception> bc) {
            super(delegate);
            this.bc = bc;
        }

        @Override
        public void onResponse(T t) {
            try {
                this.bc.accept(this.delegate, (ActionListener)t);
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.bc;
        }
    }

    static final class DelegatingFailureActionListener<T, R>
    extends DelegatingActionListener<T, R> {
        private final BiConsumer<ActionListener<R>, T> bc;

        DelegatingFailureActionListener(ActionListener<R> delegate, BiConsumer<ActionListener<R>, T> bc) {
            super(delegate);
            this.bc = bc;
        }

        @Override
        public void onResponse(T t) {
            try {
                this.bc.accept(this.delegate, (ActionListener)t);
            }
            catch (RuntimeException e) {
                ActionListenerImplementations.expectNoException(e);
            }
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.bc;
        }
    }

    static final class DelegatingResponseActionListener<T>
    extends DelegatingActionListener<T, T> {
        private final BiConsumer<ActionListener<T>, Exception> bc;

        DelegatingResponseActionListener(ActionListener<T> delegate, BiConsumer<ActionListener<T>, Exception> bc) {
            super(delegate);
            this.bc = bc;
        }

        @Override
        public void onResponse(T t) {
            this.delegate.onResponse(t);
        }

        private void acceptException(Exception e) {
            this.bc.accept(this.delegate, e);
        }

        @Override
        public void onFailure(Exception e) {
            ActionListenerImplementations.safeAcceptException(this::acceptException, e);
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.bc;
        }
    }

    static final class SafeMappedActionListener<Response, MappedResponse>
    extends DelegatingActionListener<Response, MappedResponse> {
        private final Function<Response, MappedResponse> fn;

        SafeMappedActionListener(Function<Response, MappedResponse> fn, ActionListener<MappedResponse> delegate) {
            super(delegate);
            this.fn = fn;
        }

        @Override
        public void onResponse(Response response) {
            try {
                this.delegate.onResponse(ActionListenerImplementations.applyExpectNoExceptions(this.fn, response));
            }
            catch (RuntimeException e) {
                ActionListenerImplementations.expectNoException(e);
            }
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.fn;
        }

        @Override
        public <T> ActionListener<T> map(CheckedFunction<T, Response, Exception> fn) {
            return new MappedActionListener(t -> {
                Object innerResult = fn.apply(t);
                return ActionListenerImplementations.applyExpectNoExceptions(this.fn, innerResult);
            }, this.delegate);
        }

        @Override
        public <T> ActionListener<T> safeMap(Function<T, Response> fn) {
            return new SafeMappedActionListener<T, MappedResponse>(fn.andThen(this.fn), this.delegate);
        }
    }

    static final class MappedActionListener<Response, MappedResponse>
    extends DelegatingActionListener<Response, MappedResponse> {
        private final CheckedFunction<Response, MappedResponse, Exception> fn;

        MappedActionListener(CheckedFunction<Response, MappedResponse, Exception> fn, ActionListener<MappedResponse> delegate) {
            super(delegate);
            this.fn = fn;
        }

        @Override
        public void onResponse(Response response) {
            Object mapped;
            try {
                mapped = this.fn.apply(response);
            }
            catch (Exception e) {
                this.onFailure(e);
                return;
            }
            try {
                this.delegate.onResponse(mapped);
            }
            catch (RuntimeException e) {
                ActionListenerImplementations.expectNoException(e);
            }
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.fn;
        }

        @Override
        public <T> ActionListener<T> map(CheckedFunction<T, Response, Exception> fn) {
            return new MappedActionListener<Response, MappedResponse>(t -> this.fn.apply(fn.apply(t)), this.delegate);
        }

        @Override
        public <T> ActionListener<T> safeMap(Function<T, Response> fn) {
            return new MappedActionListener<Response, MappedResponse>(t -> this.fn.apply(ActionListenerImplementations.applyExpectNoExceptions(fn, t)), this.delegate);
        }
    }
}

