/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.repositories.ResolvedRepositories;

public interface SnapshotNamePredicate {
    public static final SnapshotNamePredicate MATCH_ALL = new SnapshotNamePredicate(){

        @Override
        public boolean test(String snapshotName, boolean isCurrentSnapshot) {
            return true;
        }

        @Override
        public Collection<String> requiredNames() {
            return Collections.emptyList();
        }
    };
    public static final SnapshotNamePredicate MATCH_CURRENT_ONLY = new SnapshotNamePredicate(){

        @Override
        public boolean test(String snapshotName, boolean isCurrentSnapshot) {
            return isCurrentSnapshot;
        }

        @Override
        public Collection<String> requiredNames() {
            return Collections.emptyList();
        }
    };

    public boolean test(String var1, boolean var2);

    public Collection<String> requiredNames();

    public static SnapshotNamePredicate forSnapshots(boolean ignoreUnavailable, String[] snapshots) {
        if (ResolvedRepositories.isMatchAll(snapshots)) {
            return MATCH_ALL;
        }
        if (snapshots.length == 1 && "_current".equalsIgnoreCase(snapshots[0])) {
            return MATCH_CURRENT_ONLY;
        }
        ArrayList<String> includesBuilder = new ArrayList<String>(snapshots.length);
        ArrayList<String> excludesBuilder = new ArrayList<String>(snapshots.length);
        HashSet<String> requiredNamesBuilder = ignoreUnavailable ? null : Sets.newHashSetWithExpectedSize(snapshots.length);
        boolean seenCurrent = false;
        boolean seenWildcard = false;
        for (String snapshot : snapshots) {
            if (seenWildcard && snapshot.length() > 1 && snapshot.startsWith("-")) {
                excludesBuilder.add(snapshot.substring(1));
                continue;
            }
            if (Regex.isSimpleMatchPattern(snapshot)) {
                seenWildcard = true;
                includesBuilder.add(snapshot);
                continue;
            }
            if ("_current".equalsIgnoreCase(snapshot)) {
                seenCurrent = true;
                seenWildcard = true;
                continue;
            }
            if (!ignoreUnavailable) {
                requiredNamesBuilder.add(snapshot);
            }
            includesBuilder.add(snapshot);
        }
        final boolean includeCurrent = seenCurrent;
        final String[] includes = includesBuilder.toArray(Strings.EMPTY_ARRAY);
        final String[] excludes = excludesBuilder.toArray(Strings.EMPTY_ARRAY);
        final Set requiredNames = requiredNamesBuilder == null ? Set.of() : Set.copyOf(requiredNamesBuilder);
        return new SnapshotNamePredicate(){

            @Override
            public boolean test(String snapshotName, boolean isCurrentSnapshot) {
                return (includeCurrent && isCurrentSnapshot || Regex.simpleMatch(includes, snapshotName)) && !Regex.simpleMatch(excludes, snapshotName);
            }

            @Override
            public Collection<String> requiredNames() {
                return requiredNames;
            }
        };
    }
}

