/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.SnapshotNamePredicate;
import org.elasticsearch.action.admin.cluster.snapshots.get.SnapshotSortKey;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.AbstractThrottledTaskRunner;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThrottledIterator;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.ResolvedRepositories;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetSnapshotsAction
extends TransportMasterNodeAction<GetSnapshotsRequest, GetSnapshotsResponse> {
    public static final ActionType<GetSnapshotsResponse> TYPE = new ActionType("cluster:admin/snapshot/get");
    private static final Logger logger = LogManager.getLogger(TransportGetSnapshotsAction.class);
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportGetSnapshotsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RepositoriesService repositoriesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, GetSnapshotsRequest::new, indexNameExpressionResolver, GetSnapshotsResponse::new, threadPool.executor("management"));
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected ClusterBlockException checkBlock(GetSnapshotsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(Task task, GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) {
        assert (task instanceof CancellableTask) : task + " not cancellable";
        ResolvedRepositories resolvedRepositories = ResolvedRepositories.resolve(state, request.repositories());
        if (resolvedRepositories.hasMissingRepositories()) {
            throw new RepositoryMissingException(String.join((CharSequence)", ", resolvedRepositories.missing()));
        }
        new GetSnapshotsOperation((CancellableTask)task, resolvedRepositories.repositoryMetadata(), request.snapshots(), request.ignoreUnavailable(), request.policies(), request.sort(), request.order(), request.fromSortValue(), request.offset(), request.after(), request.size(), SnapshotsInProgress.get(state), request.verbose(), request.includeIndexNames()).runOperation(listener);
    }

    private class GetSnapshotsOperation {
        private final CancellableTask cancellableTask;
        private final List<RepositoryMetadata> repositories;
        private final SnapshotNamePredicate snapshotNamePredicate;
        private final SnapshotPredicates fromSortValuePredicates;
        private final Predicate<String> slmPolicyPredicate;
        private final SnapshotSortKey sortBy;
        private final SortOrder order;
        @Nullable
        private final String fromSortValue;
        private final int offset;
        private final Predicate<SnapshotInfo> afterPredicate;
        private final int size;
        private final SnapshotsInProgress snapshotsInProgress;
        private final boolean ignoreUnavailable;
        private final boolean verbose;
        private final boolean indices;
        private final GetSnapshotInfoExecutor getSnapshotInfoExecutor;
        private final List<SnapshotInfo> allSnapshotInfos = Collections.synchronizedList(new ArrayList());
        private final AtomicInteger totalCount = new AtomicInteger();

        GetSnapshotsOperation(CancellableTask cancellableTask, List<RepositoryMetadata> repositories, String[] snapshots, boolean ignoreUnavailable, String[] policies, SnapshotSortKey sortBy, SortOrder order, String fromSortValue, int offset, SnapshotSortKey.After after, int size, SnapshotsInProgress snapshotsInProgress, boolean verbose, boolean indices) {
            this.cancellableTask = cancellableTask;
            this.repositories = repositories;
            this.ignoreUnavailable = ignoreUnavailable;
            this.sortBy = sortBy;
            this.order = order;
            this.fromSortValue = fromSortValue;
            this.offset = offset;
            this.size = size;
            this.snapshotsInProgress = snapshotsInProgress;
            this.verbose = verbose;
            this.indices = indices;
            this.snapshotNamePredicate = SnapshotNamePredicate.forSnapshots(ignoreUnavailable, snapshots);
            this.fromSortValuePredicates = SnapshotPredicates.forFromSortValue(fromSortValue, sortBy, order);
            this.slmPolicyPredicate = SlmPolicyPredicate.forPolicies(policies);
            this.afterPredicate = sortBy.getAfterPredicate(after, order);
            this.getSnapshotInfoExecutor = new GetSnapshotInfoExecutor(TransportGetSnapshotsAction.this.threadPool.info("snapshot_meta").getMax(), cancellableTask::isCancelled);
            if (!verbose) {
                assert (this.fromSortValuePredicates.isMatchAll()) : "filtering is not supported in non-verbose mode";
                assert (this.slmPolicyPredicate == SlmPolicyPredicate.MATCH_ALL_POLICIES) : "filtering is not supported in non-verbose mode";
            }
        }

        void runOperation(ActionListener<GetSnapshotsResponse> listener) {
            SubscribableListener.newForked(this::populateResults).addListener(listener.map(ignored -> this.buildResponse()), TransportGetSnapshotsAction.this.executor, TransportGetSnapshotsAction.this.threadPool.getThreadContext());
        }

        private void populateResults(ActionListener<Void> listener) {
            try (RefCountingListener listeners = new RefCountingListener(listener);){
                for (RepositoryMetadata repository : this.repositories) {
                    String repositoryName = repository.name();
                    if (this.skipRepository(repositoryName)) continue;
                    if (listeners.isFailing()) {
                        return;
                    }
                    this.maybeGetRepositoryData(repositoryName, listeners.acquire(repositoryData -> {
                        assert (ThreadPool.assertCurrentThreadPool("management"));
                        this.cancellableTask.ensureNotCancelled();
                        this.ensureRequiredNamesPresent(repositoryName, (RepositoryData)repositoryData);
                        ThrottledIterator.run(Iterators.failFast(this.getAsyncSnapshotInfoIterator(TransportGetSnapshotsAction.this.repositoriesService.repository(repositoryName), (RepositoryData)repositoryData), () -> this.cancellableTask.isCancelled() || listeners.isFailing()), (ref, asyncSnapshotInfo) -> ActionListener.run(ActionListener.runBefore(listeners.acquire(), () -> ((Releasable)ref).close()), refListener -> asyncSnapshotInfo.getSnapshotInfo(new ActionListener<SnapshotInfo>(){

                            @Override
                            public void onResponse(SnapshotInfo snapshotInfo) {
                                if (GetSnapshotsOperation.this.matchesPredicates(snapshotInfo)) {
                                    GetSnapshotsOperation.this.totalCount.incrementAndGet();
                                    if (GetSnapshotsOperation.this.afterPredicate.test(snapshotInfo)) {
                                        GetSnapshotsOperation.this.allSnapshotInfos.add(snapshotInfo.maybeWithoutIndices(GetSnapshotsOperation.this.indices));
                                    }
                                }
                                refListener.onResponse(null);
                            }

                            @Override
                            public void onFailure(Exception e) {
                                if (GetSnapshotsOperation.this.ignoreUnavailable) {
                                    logger.warn(Strings.format("failed to fetch snapshot info for [%s]", asyncSnapshotInfo), (Throwable)e);
                                    refListener.onResponse(null);
                                } else {
                                    refListener.onFailure(e);
                                }
                            }
                        })), this.getSnapshotInfoExecutor.getMaxRunningTasks(), () -> {});
                    }));
                }
            }
        }

        private void maybeGetRepositoryData(String repositoryName, ActionListener<RepositoryData> listener) {
            if (this.snapshotNamePredicate == SnapshotNamePredicate.MATCH_CURRENT_ONLY) {
                listener.onResponse(null);
            } else {
                TransportGetSnapshotsAction.this.repositoriesService.repository(repositoryName).getRepositoryData(TransportGetSnapshotsAction.this.executor, listener);
            }
        }

        private boolean skipRepository(String repositoryName) {
            if (this.sortBy == SnapshotSortKey.REPOSITORY && this.fromSortValue != null) {
                return this.order == SortOrder.ASC ? this.fromSortValue.compareTo(repositoryName) > 0 : this.fromSortValue.compareTo(repositoryName) < 0;
            }
            return false;
        }

        private void ensureRequiredNamesPresent(String repositoryName, @Nullable RepositoryData repositoryData) {
            if (this.snapshotNamePredicate.requiredNames().isEmpty()) {
                return;
            }
            HashSet<String> unmatchedRequiredNames = new HashSet<String>(this.snapshotNamePredicate.requiredNames());
            for (SnapshotsInProgress.Entry snapshotInProgress : this.snapshotsInProgress.forRepo(repositoryName)) {
                unmatchedRequiredNames.remove(snapshotInProgress.snapshot().getSnapshotId().getName());
            }
            if (unmatchedRequiredNames.isEmpty()) {
                return;
            }
            if (repositoryData != null) {
                for (SnapshotId snapshotId : repositoryData.getSnapshotIds()) {
                    unmatchedRequiredNames.remove(snapshotId.getName());
                }
                if (unmatchedRequiredNames.isEmpty()) {
                    return;
                }
            }
            throw new SnapshotMissingException(repositoryName, unmatchedRequiredNames.iterator().next());
        }

        private AsyncSnapshotInfo forSnapshotInProgress(final SnapshotsInProgress.Entry snapshotInProgress) {
            return new AsyncSnapshotInfo(){

                @Override
                public void getSnapshotInfo(ActionListener<SnapshotInfo> listener) {
                    assert (ThreadPool.assertCurrentThreadPool("management"));
                    SnapshotInfo snapshotInfo = SnapshotInfo.inProgress(snapshotInProgress);
                    listener.onResponse(GetSnapshotsOperation.this.verbose ? snapshotInfo : snapshotInfo.basic());
                }

                public String toString() {
                    return snapshotInProgress.snapshot().toString();
                }
            };
        }

        private AsyncSnapshotInfo forCompletedSnapshot(final Repository repository, final SnapshotId snapshotId, final RepositoryData repositoryData, final Map<SnapshotId, List<String>> indicesLookup) {
            return new AsyncSnapshotInfo(){

                @Override
                public void getSnapshotInfo(ActionListener<SnapshotInfo> listener) {
                    if (GetSnapshotsOperation.this.verbose) {
                        assert (ThreadPool.assertCurrentThreadPool("management", "snapshot_meta"));
                        GetSnapshotsOperation.this.getSnapshotInfoExecutor.getSnapshotInfo(repository, snapshotId, listener);
                    } else {
                        assert (ThreadPool.assertCurrentThreadPool("management"));
                        ActionListener.completeWith(listener, () -> new SnapshotInfo(new Snapshot(repository.getMetadata().name(), snapshotId), indicesLookup.getOrDefault(snapshotId, Collections.emptyList()), Collections.emptyList(), Collections.emptyList(), repositoryData.getSnapshotState(snapshotId)));
                    }
                }

                public String toString() {
                    return repository.getMetadata().name() + ":" + snapshotId;
                }
            };
        }

        private Iterator<AsyncSnapshotInfo> getAsyncSnapshotInfoIterator(Repository repository, @Nullable RepositoryData repositoryData) {
            HashSet matchingInProgressSnapshots = new HashSet();
            Map<SnapshotId, List<String>> indicesLookup = this.getIndicesLookup(repositoryData);
            return Iterators.concat(Iterators.map(Iterators.filter(this.snapshotsInProgress.forRepo(repository.getMetadata().name()).iterator(), snapshotInProgress -> {
                SnapshotId snapshotId = snapshotInProgress.snapshot().getSnapshotId();
                if (this.snapshotNamePredicate.test(snapshotId.getName(), true)) {
                    matchingInProgressSnapshots.add(snapshotId);
                    return true;
                }
                return false;
            }), this::forSnapshotInProgress), repositoryData == null ? Collections.emptyIterator() : Iterators.map(Iterators.filter(repositoryData.getSnapshotIds().iterator(), snapshotId -> !matchingInProgressSnapshots.contains(snapshotId) && this.snapshotNamePredicate.test(snapshotId.getName(), false) && this.matchesPredicates((SnapshotId)snapshotId, repositoryData)), snapshotId -> this.forCompletedSnapshot(repository, (SnapshotId)snapshotId, repositoryData, indicesLookup)));
        }

        @Nullable
        private Map<SnapshotId, List<String>> getIndicesLookup(RepositoryData repositoryData) {
            if (repositoryData == null || this.verbose || !this.indices) {
                return Map.of();
            }
            HashMap<SnapshotId, List<String>> snapshotsToIndices = new HashMap<SnapshotId, List<String>>();
            for (IndexId indexId : repositoryData.getIndices().values()) {
                for (SnapshotId snapshotId : repositoryData.getSnapshots(indexId)) {
                    if (!this.snapshotNamePredicate.test(snapshotId.getName(), false) || !this.matchesPredicates(snapshotId, repositoryData)) continue;
                    snapshotsToIndices.computeIfAbsent(snapshotId, k -> new ArrayList()).add(indexId.getName());
                }
            }
            return snapshotsToIndices;
        }

        private GetSnapshotsResponse buildResponse() {
            List<SnapshotInfo> snapshotInfos;
            assert (ThreadPool.assertCurrentThreadPool("management"));
            this.cancellableTask.ensureNotCancelled();
            int remaining = 0;
            Stream<SnapshotInfo> resultsStream = this.allSnapshotInfos.stream().peek(this::assertSatisfiesAllPredicates).sorted(this.sortBy.getSnapshotInfoComparator(this.order)).skip(this.offset);
            if (this.size == -1 || this.allSnapshotInfos.size() <= this.size) {
                snapshotInfos = resultsStream.toList();
            } else {
                snapshotInfos = new ArrayList<SnapshotInfo>(this.size);
                Iterator iterator = resultsStream.iterator();
                while (iterator.hasNext()) {
                    SnapshotInfo snapshotInfo = (SnapshotInfo)iterator.next();
                    if (snapshotInfos.size() < this.size) {
                        snapshotInfos.add(snapshotInfo);
                        continue;
                    }
                    ++remaining;
                }
            }
            return new GetSnapshotsResponse(snapshotInfos, null, remaining > 0 ? this.sortBy.encodeAfterQueryParam(snapshotInfos.get(snapshotInfos.size() - 1)) : null, this.totalCount.get(), remaining);
        }

        private void assertSatisfiesAllPredicates(SnapshotInfo snapshotInfo) {
            assert (this.matchesPredicates(snapshotInfo));
            assert (this.afterPredicate.test(snapshotInfo));
            assert (this.indices || snapshotInfo.indices().isEmpty());
        }

        private boolean matchesPredicates(SnapshotId snapshotId, RepositoryData repositoryData) {
            if (!this.fromSortValuePredicates.test(snapshotId, repositoryData)) {
                return false;
            }
            if (this.slmPolicyPredicate == SlmPolicyPredicate.MATCH_ALL_POLICIES) {
                return true;
            }
            RepositoryData.SnapshotDetails details = repositoryData.getSnapshotDetails(snapshotId);
            return details == null || details.getSlmPolicy() == null || this.slmPolicyPredicate.test(details.getSlmPolicy());
        }

        private boolean matchesPredicates(SnapshotInfo snapshotInfo) {
            String s;
            Object object;
            if (!this.fromSortValuePredicates.test(snapshotInfo)) {
                return false;
            }
            if (this.slmPolicyPredicate == SlmPolicyPredicate.MATCH_ALL_POLICIES) {
                return true;
            }
            Map<String, Object> metadata = snapshotInfo.userMetadata();
            return this.slmPolicyPredicate.test(metadata != null && (object = metadata.get("policy")) instanceof String ? (s = (String)object) : "");
        }

        private static interface AsyncSnapshotInfo {
            public void getSnapshotInfo(ActionListener<SnapshotInfo> var1);
        }
    }

    private record SlmPolicyPredicate(String[] includes, String[] excludes, boolean matchWithoutPolicy) implements Predicate<String>
    {
        static final Predicate<String> MATCH_ALL_POLICIES = Predicates.always();

        @Override
        public boolean test(String policy) {
            if (policy.equals("")) {
                return this.matchWithoutPolicy;
            }
            if (!Regex.simpleMatch(this.includes, policy)) {
                return false;
            }
            return this.excludes.length == 0 || !Regex.simpleMatch(this.excludes, policy);
        }

        static Predicate<String> forPolicies(String[] slmPolicies) {
            if (slmPolicies.length == 0) {
                return MATCH_ALL_POLICIES;
            }
            ArrayList<String> includePatterns = new ArrayList<String>(slmPolicies.length);
            ArrayList<String> excludePatterns = new ArrayList<String>(slmPolicies.length);
            boolean seenWildcard = false;
            boolean matchNoPolicy = false;
            for (String slmPolicy : slmPolicies) {
                if (seenWildcard && slmPolicy.length() > 1 && slmPolicy.startsWith("-")) {
                    excludePatterns.add(slmPolicy.substring(1));
                    continue;
                }
                if (Regex.isSimpleMatchPattern(slmPolicy)) {
                    seenWildcard = true;
                } else if ("_none".equals(slmPolicy)) {
                    matchNoPolicy = true;
                }
                includePatterns.add(slmPolicy);
            }
            return new SlmPolicyPredicate(includePatterns.toArray(Strings.EMPTY_ARRAY), excludePatterns.toArray(Strings.EMPTY_ARRAY), matchNoPolicy);
        }
    }

    private static class GetSnapshotInfoExecutor
    extends AbstractThrottledTaskRunner<ActionListener<Releasable>> {
        private final int maxRunningTasks;
        private final BooleanSupplier isCancelledSupplier;

        GetSnapshotInfoExecutor(int maxRunningTasks, BooleanSupplier isCancelledSupplier) {
            super(TYPE.name(), maxRunningTasks, EsExecutors.DIRECT_EXECUTOR_SERVICE, ConcurrentCollections.newBlockingQueue());
            this.maxRunningTasks = maxRunningTasks;
            this.isCancelledSupplier = isCancelledSupplier;
        }

        int getMaxRunningTasks() {
            return this.maxRunningTasks;
        }

        void getSnapshotInfo(Repository repository, SnapshotId snapshotId, ActionListener<SnapshotInfo> listener) {
            this.enqueueTask(listener.delegateFailure((l, ref) -> {
                if (this.isCancelledSupplier.getAsBoolean()) {
                    l.onFailure(new TaskCancelledException("task cancelled"));
                } else {
                    repository.getSnapshotInfo(snapshotId, ActionListener.releaseAfter(l, ref));
                }
            }));
        }
    }

    private static final class SnapshotPredicates {
        private static final SnapshotPredicates MATCH_ALL = new SnapshotPredicates(null, null);
        @Nullable
        private final BiPredicate<SnapshotId, RepositoryData> preflightPredicate;
        @Nullable
        private final Predicate<SnapshotInfo> snapshotPredicate;

        private SnapshotPredicates(@Nullable BiPredicate<SnapshotId, RepositoryData> preflightPredicate, @Nullable Predicate<SnapshotInfo> snapshotPredicate) {
            this.snapshotPredicate = snapshotPredicate;
            this.preflightPredicate = preflightPredicate;
        }

        boolean test(SnapshotId snapshotId, RepositoryData repositoryData) {
            return this.preflightPredicate == null || this.preflightPredicate.test(snapshotId, repositoryData);
        }

        boolean isMatchAll() {
            return this.snapshotPredicate == null;
        }

        boolean test(SnapshotInfo snapshotInfo) {
            return this.snapshotPredicate == null || this.snapshotPredicate.test(snapshotInfo);
        }

        static SnapshotPredicates forFromSortValue(String fromSortValue, SnapshotSortKey sortBy, SortOrder order) {
            if (fromSortValue == null) {
                return MATCH_ALL;
            }
            switch (sortBy) {
                case START_TIME: {
                    long after = Long.parseLong(fromSortValue);
                    return new SnapshotPredicates(order == SortOrder.ASC ? (snapshotId, repositoryData) -> {
                        long startTime = SnapshotPredicates.getStartTime(snapshotId, repositoryData);
                        return startTime == -1L || after <= startTime;
                    } : (snapshotId, repositoryData) -> {
                        long startTime = SnapshotPredicates.getStartTime(snapshotId, repositoryData);
                        return startTime == -1L || after >= startTime;
                    }, SnapshotPredicates.filterByLongOffset(SnapshotInfo::startTime, after, order));
                }
                case NAME: {
                    return new SnapshotPredicates(order == SortOrder.ASC ? (snapshotId, repositoryData) -> fromSortValue.compareTo(snapshotId.getName()) <= 0 : (snapshotId, repositoryData) -> fromSortValue.compareTo(snapshotId.getName()) >= 0, null);
                }
                case DURATION: {
                    long afterDuration = Long.parseLong(fromSortValue);
                    return new SnapshotPredicates(order == SortOrder.ASC ? (snapshotId, repositoryData) -> {
                        long duration = SnapshotPredicates.getDuration(snapshotId, repositoryData);
                        return duration == -1L || afterDuration <= duration;
                    } : (snapshotId, repositoryData) -> {
                        long duration = SnapshotPredicates.getDuration(snapshotId, repositoryData);
                        return duration == -1L || afterDuration >= duration;
                    }, SnapshotPredicates.filterByLongOffset(info -> info.endTime() - info.startTime(), afterDuration, order));
                }
                case INDICES: {
                    int afterIndexCount = Integer.parseInt(fromSortValue);
                    return new SnapshotPredicates(order == SortOrder.ASC ? (snapshotId, repositoryData) -> afterIndexCount <= SnapshotPredicates.indexCount(snapshotId, repositoryData) : (snapshotId, repositoryData) -> afterIndexCount >= SnapshotPredicates.indexCount(snapshotId, repositoryData), null);
                }
                case REPOSITORY: {
                    return MATCH_ALL;
                }
                case SHARDS: {
                    return new SnapshotPredicates(null, SnapshotPredicates.filterByLongOffset(SnapshotInfo::totalShards, Integer.parseInt(fromSortValue), order));
                }
                case FAILED_SHARDS: {
                    return new SnapshotPredicates(null, SnapshotPredicates.filterByLongOffset(SnapshotInfo::failedShards, Integer.parseInt(fromSortValue), order));
                }
            }
            throw new AssertionError((Object)("unexpected sort column [" + sortBy + "]"));
        }

        private static Predicate<SnapshotInfo> filterByLongOffset(ToLongFunction<SnapshotInfo> extractor, long after, SortOrder order) {
            return order == SortOrder.ASC ? info -> after <= extractor.applyAsLong((SnapshotInfo)info) : info -> after >= extractor.applyAsLong((SnapshotInfo)info);
        }

        private static long getDuration(SnapshotId snapshotId, RepositoryData repositoryData) {
            RepositoryData.SnapshotDetails details = repositoryData.getSnapshotDetails(snapshotId);
            if (details == null) {
                return -1L;
            }
            long startTime = details.getStartTimeMillis();
            if (startTime == -1L) {
                return -1L;
            }
            long endTime = details.getEndTimeMillis();
            if (endTime == -1L) {
                return -1L;
            }
            return endTime - startTime;
        }

        private static long getStartTime(SnapshotId snapshotId, RepositoryData repositoryData) {
            RepositoryData.SnapshotDetails details = repositoryData.getSnapshotDetails(snapshotId);
            return details == null ? -1L : details.getStartTimeMillis();
        }

        private static int indexCount(SnapshotId snapshotId, RepositoryData repositoryData) {
            int indexCount = 0;
            for (IndexId idx : repositoryData.getIndices().values()) {
                if (!repositoryData.getSnapshots(idx).contains(snapshotId)) continue;
                ++indexCount;
            }
            return indexCount;
        }
    }
}

