/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.TransportGetFieldMappingsIndexAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetFieldMappingsAction
extends HandledTransportAction<GetFieldMappingsRequest, GetFieldMappingsResponse> {
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final NodeClient client;

    @Inject
    public TransportGetFieldMappingsAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client) {
        super("indices:admin/mappings/fields/get", transportService, actionFilters, GetFieldMappingsRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
    }

    @Override
    protected void doExecute(Task task, GetFieldMappingsRequest request, final ActionListener<GetFieldMappingsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request);
        final AtomicInteger indexCounter = new AtomicInteger();
        final AtomicInteger completionCounter = new AtomicInteger(concreteIndices.length);
        final AtomicReferenceArray indexResponses = new AtomicReferenceArray(concreteIndices.length);
        if (concreteIndices.length == 0) {
            listener.onResponse(new GetFieldMappingsResponse(Collections.emptyMap()));
        } else {
            for (String index : concreteIndices) {
                GetFieldMappingsIndexRequest shardRequest = new GetFieldMappingsIndexRequest(request, index);
                this.client.executeLocally(TransportGetFieldMappingsIndexAction.TYPE, shardRequest, new ActionListener<GetFieldMappingsResponse>(){

                    @Override
                    public void onResponse(GetFieldMappingsResponse result) {
                        indexResponses.set(indexCounter.getAndIncrement(), result);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse(TransportGetFieldMappingsAction.merge(indexResponses));
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        int index = indexCounter.getAndIncrement();
                        indexResponses.set(index, e);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse(TransportGetFieldMappingsAction.merge(indexResponses));
                        }
                    }
                });
            }
        }
    }

    private static GetFieldMappingsResponse merge(AtomicReferenceArray<Object> indexResponses) {
        HashMap<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>> mergedResponses = new HashMap<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>>();
        for (int i = 0; i < indexResponses.length(); ++i) {
            Object element = indexResponses.get(i);
            if (!(element instanceof GetFieldMappingsResponse)) continue;
            GetFieldMappingsResponse response = (GetFieldMappingsResponse)element;
            mergedResponses.putAll(response.mappings());
        }
        return new GetFieldMappingsResponse(Collections.unmodifiableMap(mergedResponses));
    }
}

