/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.readonly;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.readonly.TransportAddIndexBlockAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportVerifyShardIndexBlockAction
extends TransportReplicationAction<ShardRequest, ShardRequest, ReplicationResponse> {
    public static final ActionType<ReplicationResponse> TYPE = new ActionType(TransportAddIndexBlockAction.TYPE.name() + "[s]");

    @Inject
    public TransportVerifyShardIndexBlockAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction stateAction, ActionFilters actionFilters) {
        super(settings, TYPE.name(), transportService, clusterService, indicesService, threadPool, stateAction, actionFilters, ShardRequest::new, ShardRequest::new, threadPool.executor("management"), TransportReplicationAction.SyncGlobalCheckpointAfterOperation.DoNotSync, TransportReplicationAction.PrimaryActionExecution.RejectOnOverload, TransportReplicationAction.ReplicaActionExecution.SubjectToCircuitBreaker);
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void acquirePrimaryOperationPermit(IndexShard primary, ShardRequest request, ActionListener<Releasable> onAcquired) {
        primary.acquireAllPrimaryOperationsPermits(onAcquired, request.timeout());
    }

    @Override
    protected void acquireReplicaOperationPermit(IndexShard replica, ShardRequest request, ActionListener<Releasable> onAcquired, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdateOrDeletes) {
        replica.acquireAllReplicaOperationsPermits(primaryTerm, globalCheckpoint, maxSeqNoOfUpdateOrDeletes, onAcquired, request.timeout());
    }

    @Override
    protected void shardOperationOnPrimary(ShardRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ShardRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            this.executeShardOperation(shardRequest, primary);
            return new TransportReplicationAction.PrimaryResult<ShardRequest, ReplicationResponse>(shardRequest, new ReplicationResponse());
        });
    }

    @Override
    protected void shardOperationOnReplica(ShardRequest shardRequest, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            this.executeShardOperation(shardRequest, replica);
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    private void executeShardOperation(ShardRequest request, IndexShard indexShard) {
        ShardId shardId = indexShard.shardId();
        if (indexShard.getActiveOperationsCount() != -1) {
            throw new IllegalStateException("index shard " + shardId + " is not blocking all operations while waiting for block " + request.clusterBlock());
        }
        ClusterBlocks clusterBlocks = this.clusterService.state().blocks();
        if (!clusterBlocks.hasIndexBlock(shardId.getIndexName(), request.clusterBlock())) {
            throw new IllegalStateException("index shard " + shardId + " has not applied block " + request.clusterBlock());
        }
    }

    @Override
    protected ReplicationOperation.Replicas<ShardRequest> newReplicasProxy() {
        return new VerifyShardReadOnlyActionReplicasProxy();
    }

    public static final class ShardRequest
    extends ReplicationRequest<ShardRequest> {
        private final ClusterBlock clusterBlock;

        ShardRequest(StreamInput in) throws IOException {
            super(in);
            this.clusterBlock = new ClusterBlock(in);
        }

        public ShardRequest(ShardId shardId, ClusterBlock clusterBlock, TaskId parentTaskId) {
            super(shardId);
            this.clusterBlock = Objects.requireNonNull(clusterBlock);
            this.setParentTask(parentTaskId);
        }

        @Override
        public String toString() {
            return "verify shard " + this.shardId + " before block with " + this.clusterBlock;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.clusterBlock.writeTo(out);
        }

        public ClusterBlock clusterBlock() {
            return this.clusterBlock;
        }
    }

    class VerifyShardReadOnlyActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        VerifyShardReadOnlyActionReplicasProxy() {
            super(TransportVerifyShardIndexBlockAction.this);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            TransportVerifyShardIndexBlockAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, primaryTerm, true, "mark copy as stale", null, listener);
        }
    }
}

