/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.put;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndexMappingUpdateService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateSettingsAction
extends AcknowledgedTransportMasterNodeAction<UpdateSettingsRequest> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("indices:admin/settings/update");
    private static final Logger logger = LogManager.getLogger(TransportUpdateSettingsAction.class);
    private final MetadataUpdateSettingsService updateSettingsService;
    private final SystemIndices systemIndices;

    @Inject
    public TransportUpdateSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataUpdateSettingsService updateSettingsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, UpdateSettingsRequest::new, indexNameExpressionResolver, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.updateSettingsService = updateSettingsService;
        this.systemIndices = systemIndices;
    }

    @Override
    protected ClusterBlockException checkBlock(UpdateSettingsRequest request, ClusterState state) {
        ClusterBlockException globalBlock = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (globalBlock != null) {
            return globalBlock;
        }
        if (request.settings().size() == 1 && IndexMetadata.INDEX_BLOCKS_METADATA_SETTING.exists(request.settings()) || IndexMetadata.INDEX_READ_ONLY_SETTING.exists(request.settings()) || IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.exists(request.settings())) {
            return null;
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(Task task, UpdateSettingsRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
        Settings requestSettings = request.settings();
        Map<String, List<String>> systemIndexViolations = this.checkForSystemIndexViolations(concreteIndices, request);
        if (!systemIndexViolations.isEmpty()) {
            String message = "Cannot override settings on system indices: " + systemIndexViolations.entrySet().stream().map(entry -> "[" + (String)entry.getKey() + "] -> " + entry.getValue()).collect(Collectors.joining(", "));
            logger.warn(message);
            listener.onFailure(new IllegalStateException(message));
            return;
        }
        List<String> unhiddenSystemIndexViolations = this.checkForUnhidingSystemIndex(concreteIndices, request);
        if (!unhiddenSystemIndexViolations.isEmpty()) {
            String message = "Cannot set [index.hidden] to 'false' on system indices: " + unhiddenSystemIndexViolations.stream().map(entry -> "[" + entry + "]").collect(Collectors.joining(", "));
            logger.warn(message);
            listener.onFailure(new IllegalStateException(message));
            return;
        }
        this.updateSettingsService.updateSettings(new UpdateSettingsClusterStateUpdateRequest(request.masterNodeTimeout(), request.ackTimeout(), requestSettings, request.isPreserveExisting() ? UpdateSettingsClusterStateUpdateRequest.OnExisting.PRESERVE : UpdateSettingsClusterStateUpdateRequest.OnExisting.OVERWRITE, request.reopen() ? UpdateSettingsClusterStateUpdateRequest.OnStaticSetting.REOPEN_INDICES : UpdateSettingsClusterStateUpdateRequest.OnStaticSetting.REJECT, concreteIndices), listener.delegateResponse((l, e) -> {
            logger.debug(() -> "failed to update settings on indices [" + Arrays.toString(concreteIndices) + "]", (Throwable)e);
            l.onFailure((Exception)e);
        }));
    }

    private Map<String, List<String>> checkForSystemIndexViolations(Index[] concreteIndices, UpdateSettingsRequest request) {
        if (!Strings.isNullOrEmpty(request.origin())) {
            return Map.of();
        }
        HashMap<String, List<String>> violationsByIndex = new HashMap<String, List<String>>();
        Settings requestSettings = request.settings();
        for (Index index : concreteIndices) {
            SystemIndexDescriptor descriptor = this.systemIndices.findMatchingDescriptor(index.getName());
            if (descriptor == null || !descriptor.isAutomaticallyManaged()) continue;
            Settings descriptorSettings = descriptor.getSettings();
            ArrayList<String> failedKeys = new ArrayList<String>();
            for (String key : requestSettings.keySet()) {
                String actualValue;
                String expectedValue;
                if (SystemIndexMappingUpdateService.MANAGED_SYSTEM_INDEX_SETTING_UPDATE_ALLOWLIST.contains(key) || Objects.equals(expectedValue = descriptorSettings.get(key), actualValue = requestSettings.get(key))) continue;
                failedKeys.add(key);
            }
            if (failedKeys.isEmpty()) continue;
            violationsByIndex.put(descriptor.getIndexPattern(), failedKeys);
        }
        return violationsByIndex;
    }

    private List<String> checkForUnhidingSystemIndex(Index[] concreteIndices, UpdateSettingsRequest request) {
        if (request.settings().getAsBoolean("index.hidden", true).booleanValue()) {
            return List.of();
        }
        ArrayList<String> systemPatterns = new ArrayList<String>();
        for (Index index : concreteIndices) {
            SystemIndexDescriptor descriptor = this.systemIndices.findMatchingDescriptor(index.getName());
            if (descriptor == null) continue;
            systemPatterns.add(index.getName());
        }
        return systemPatterns;
    }
}

