/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.TimeValue;

public class DeleteDataStreamAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteDataStreamAction INSTANCE = new DeleteDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/delete";

    private DeleteDataStreamAction() {
        super(NAME);
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;
        private final boolean wildcardExpressionsOriginallySpecified;
        private IndicesOptions indicesOptions = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(true).resolveAliases(false).allowEmptyExpressions(true).build()).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().allowAliasToMultipleIndices(false).allowClosedIndices(true).ignoreThrottled(false).allowFailureIndices(true).build()).build();

        public Request(TimeValue masterNodeTimeout, String ... names) {
            super(masterNodeTimeout);
            this.names = Objects.requireNonNull(names);
            this.wildcardExpressionsOriginallySpecified = Arrays.stream(names).anyMatch(Regex::isSimpleMatchPattern);
        }

        public String[] getNames() {
            return this.names;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (CollectionUtils.isEmpty(this.names)) {
                validationException = ValidateActions.addValidationError("no data stream(s) specified", validationException);
            }
            return validationException;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
            this.wildcardExpressionsOriginallySpecified = in.readBoolean();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
            out.writeBoolean(this.wildcardExpressionsOriginallySpecified);
            this.indicesOptions.writeIndicesOptions(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.wildcardExpressionsOriginallySpecified == request.wildcardExpressionsOriginallySpecified && Arrays.equals(this.names, request.names) && this.indicesOptions.equals(request.indicesOptions);
        }

        public int hashCode() {
            int result = Objects.hash(this.wildcardExpressionsOriginallySpecified, this.indicesOptions);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public Request indicesOptions(IndicesOptions options) {
            this.indicesOptions = options;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        public boolean isWildcardExpressionsOriginallySpecified() {
            return this.wildcardExpressionsOriginallySpecified;
        }
    }
}

