/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

class FieldCapabilitiesNodeRequest
extends ActionRequest
implements IndicesRequest {
    private final List<ShardId> shardIds;
    private final String[] fields;
    private final String[] filters;
    private final String[] allowedTypes;
    private final OriginalIndices originalIndices;
    private final QueryBuilder indexFilter;
    private final long nowInMillis;
    private final Map<String, Object> runtimeFields;
    private final boolean includeEmptyFields;

    FieldCapabilitiesNodeRequest(StreamInput in) throws IOException {
        super(in);
        this.shardIds = in.readCollectionAsList(ShardId::new);
        this.fields = in.readStringArray();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            this.filters = in.readStringArray();
            this.allowedTypes = in.readStringArray();
        } else {
            this.filters = Strings.EMPTY_ARRAY;
            this.allowedTypes = Strings.EMPTY_ARRAY;
        }
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        this.indexFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nowInMillis = in.readLong();
        this.runtimeFields = in.readGenericMap();
        this.includeEmptyFields = in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) ? in.readBoolean() : true;
    }

    FieldCapabilitiesNodeRequest(List<ShardId> shardIds, String[] fields, String[] filters, String[] allowedTypes, OriginalIndices originalIndices, QueryBuilder indexFilter, long nowInMillis, Map<String, Object> runtimeFields, boolean includeEmptyFields) {
        this.shardIds = Objects.requireNonNull(shardIds);
        this.fields = fields;
        this.filters = filters;
        this.allowedTypes = allowedTypes;
        this.originalIndices = originalIndices;
        this.indexFilter = indexFilter;
        this.nowInMillis = nowInMillis;
        this.runtimeFields = runtimeFields;
        this.includeEmptyFields = includeEmptyFields;
    }

    public String[] fields() {
        return this.fields;
    }

    public String[] filters() {
        return this.filters;
    }

    public String[] allowedTypes() {
        return this.allowedTypes;
    }

    public OriginalIndices originalIndices() {
        return this.originalIndices;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    public Map<String, Object> runtimeFields() {
        return this.runtimeFields;
    }

    public List<ShardId> shardIds() {
        return this.shardIds;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public boolean includeEmptyFields() {
        return this.includeEmptyFields;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.shardIds);
        out.writeStringArray(this.fields);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            out.writeStringArray(this.filters);
            out.writeStringArray(this.allowedTypes);
        }
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        out.writeOptionalNamedWriteable(this.indexFilter);
        out.writeLong(this.nowInMillis);
        out.writeGenericMap(this.runtimeFields);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            out.writeBoolean(this.includeEmptyFields);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("shards[");
        Strings.collectionToDelimitedStringWithLimit(this.shardIds, ",", "", "", 1024, stringBuilder);
        return FieldCapabilitiesNodeRequest.completeDescription(stringBuilder, this.fields, this.filters, this.allowedTypes, this.includeEmptyFields);
    }

    static String completeDescription(StringBuilder stringBuilder, String[] fields, String[] filters, String[] allowedTypes, boolean includeEmptyFields) {
        stringBuilder.append("], fields[");
        Strings.collectionToDelimitedStringWithLimit(Arrays.asList(fields), ",", "", "", 1024, stringBuilder);
        stringBuilder.append("], filters[");
        Strings.collectionToDelimitedString(Arrays.asList(filters), ",", "", "", stringBuilder);
        stringBuilder.append("], types[");
        Strings.collectionToDelimitedString(Arrays.asList(allowedTypes), ",", "", "", stringBuilder);
        stringBuilder.append("], includeEmptyFields[");
        stringBuilder.append(includeEmptyFields);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                return FieldCapabilitiesNodeRequest.this.getDescription();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesNodeRequest that = (FieldCapabilitiesNodeRequest)o;
        return this.nowInMillis == that.nowInMillis && this.shardIds.equals(that.shardIds) && Arrays.equals(this.fields, that.fields) && Arrays.equals(this.filters, that.filters) && Arrays.equals(this.allowedTypes, that.allowedTypes) && Objects.equals(this.originalIndices, that.originalIndices) && Objects.equals(this.indexFilter, that.indexFilter) && Objects.equals(this.runtimeFields, that.runtimeFields) && this.includeEmptyFields == that.includeEmptyFields;
    }

    public int hashCode() {
        int result = Objects.hash(this.originalIndices, this.indexFilter, this.nowInMillis, this.runtimeFields, this.includeEmptyFields);
        result = 31 * result + this.shardIds.hashCode();
        result = 31 * result + Arrays.hashCode(this.fields);
        result = 31 * result + Arrays.hashCode(this.filters);
        result = 31 * result + Arrays.hashCode(this.allowedTypes);
        return result;
    }
}

