/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public final class OpenPointInTimeRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    private String[] indices;
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
    private TimeValue keepAlive;
    private int maxConcurrentShardRequests = 5;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private QueryBuilder indexFilter;
    private boolean allowPartialSearchResults = false;
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = SearchRequest.DEFAULT_INDICES_OPTIONS;

    public OpenPointInTimeRequest(String ... indices) {
        this.indices = Objects.requireNonNull(indices, "[index] is not specified");
    }

    public OpenPointInTimeRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.keepAlive = in.readTimeValue();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            this.maxConcurrentShardRequests = in.readVInt();
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            this.indexFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.ALLOW_PARTIAL_SEARCH_RESULTS_IN_PIT)) {
            this.allowPartialSearchResults = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeTimeValue(this.keepAlive);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeVInt(this.maxConcurrentShardRequests);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeOptionalWriteable(this.indexFilter);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.ALLOW_PARTIAL_SEARCH_RESULTS_IN_PIT)) {
            out.writeBoolean(this.allowPartialSearchResults);
        } else if (this.allowPartialSearchResults) {
            throw new IOException("[allow_partial_search_results] is not supported on nodes with version " + out.getTransportVersion());
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null || this.indices.length == 0) {
            validationException = ValidateActions.addValidationError("[index] is not specified", validationException);
        }
        if (this.keepAlive == null) {
            validationException = ValidateActions.addValidationError("[keep_alive] is not specified", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public OpenPointInTimeRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public OpenPointInTimeRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "[indices_options] parameter must be non null");
        return this;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public OpenPointInTimeRequest keepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public OpenPointInTimeRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public OpenPointInTimeRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public int maxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests;
    }

    public void maxConcurrentShardRequests(int maxConcurrentShardRequests) {
        if (maxConcurrentShardRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentShardRequests must be >= 1");
        }
        this.maxConcurrentShardRequests = maxConcurrentShardRequests;
    }

    public void indexFilter(QueryBuilder indexFilter) {
        this.indexFilter = indexFilter;
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    @Override
    public boolean allowsRemoteIndices() {
        return true;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public OpenPointInTimeRequest allowPartialSearchResults(boolean allowPartialSearchResults) {
        this.allowPartialSearchResults = allowPartialSearchResults;
        return this;
    }

    @Override
    public String getDescription() {
        return "open search context: indices [" + String.join((CharSequence)",", this.indices) + "] keep_alive [" + this.keepAlive + "]";
    }

    @Override
    public String toString() {
        return "OpenPointInTimeRequest{indices=" + Arrays.toString(this.indices) + ", keepAlive=" + this.keepAlive + ", maxConcurrentShardRequests=" + this.maxConcurrentShardRequests + ", routing='" + this.routing + "', preference='" + this.preference + "', allowPartialSearchResults=" + this.allowPartialSearchResults + "}";
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this::getDescription, parentTaskId, headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenPointInTimeRequest that = (OpenPointInTimeRequest)o;
        return this.maxConcurrentShardRequests == that.maxConcurrentShardRequests && Arrays.equals(this.indices, that.indices) && this.indicesOptions.equals(that.indicesOptions) && this.keepAlive.equals((Object)that.keepAlive) && Objects.equals(this.routing, that.routing) && Objects.equals(this.preference, that.preference) && Objects.equals(this.allowPartialSearchResults, that.allowPartialSearchResults);
    }

    public int hashCode() {
        int result = Objects.hash(this.indicesOptions, this.keepAlive, this.maxConcurrentShardRequests, this.routing, this.preference, this.allowPartialSearchResults);
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }
}

