/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.plugins.Platforms;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.PluginsUtils;

final class Spawner
implements Closeable {
    private final List<Process> processes = new ArrayList<Process>();
    private final List<Thread> pumpThreads = new ArrayList<Thread>();
    private AtomicBoolean spawned = new AtomicBoolean();

    Spawner() {
    }

    @Override
    public void close() throws IOException {
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        closeables.addAll(this.processes.stream().map(s -> s::destroy).toList());
        closeables.addAll(this.pumpThreads.stream().map(t -> () -> {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).toList());
        IOUtils.close(closeables);
    }

    void spawnNativeControllers(Environment environment) throws IOException {
        if (!this.spawned.compareAndSet(false, true)) {
            throw new IllegalStateException("native controllers already spawned");
        }
        if (!Files.exists(environment.modulesFile(), new LinkOption[0])) {
            throw new IllegalStateException("modules directory [" + environment.modulesFile() + "] not found");
        }
        List<Path> paths = PluginsUtils.findPluginDirs(environment.modulesFile());
        for (Path modules : paths) {
            PluginDescriptor info = PluginDescriptor.readFromProperties(modules);
            Path spawnPath = Platforms.nativeControllerPath(modules);
            if (!Files.isRegularFile(spawnPath, new LinkOption[0])) continue;
            if (!info.hasNativeController()) {
                String message = String.format(Locale.ROOT, "module [%s] does not have permission to fork native controller", modules.getFileName());
                throw new IllegalArgumentException(message);
            }
            Process process = Spawner.spawnNativeController(spawnPath, environment.tmpFile());
            this.startPumpThread(info.getName(), "stdout", process.getInputStream());
            this.startPumpThread(info.getName(), "stderr", process.getErrorStream());
            this.processes.add(process);
        }
    }

    private void startPumpThread(String componentName, String streamName, InputStream stream) {
        String loggerName = componentName + "-controller-" + streamName;
        Logger logger = LogManager.getLogger((String)loggerName);
        Thread t = new Thread(() -> {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    logger.warn(line);
                }
            }
            catch (IOException e) {
                logger.error("error while reading " + streamName, (Throwable)e);
            }
        }, loggerName + "-pump");
        t.start();
        this.pumpThreads.add(t);
    }

    private static Process spawnNativeController(Path spawnPath, Path tmpPath) throws IOException {
        String command = Constants.WINDOWS ? NativeAccess.instance().getWindowsFunctions().getShortPathName(spawnPath.toString()) : spawnPath.toString();
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.environment().clear();
        pb.environment().put("TMPDIR", tmpPath.toString());
        return pb.start();
    }

    List<Process> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }
}

