/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.coordination.JoinReason;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.collect.Iterators;

public record JoinTask(List<NodeJoinTask> nodeJoinTasks, boolean isBecomingMaster, long term, ClusterState initialState) implements ClusterStateTaskListener
{
    public static JoinTask singleNode(DiscoveryNode node, CompatibilityVersions compatibilityVersions, Set<String> features, JoinReason reason, ActionListener<Void> listener, long term) {
        return new JoinTask(List.of(new NodeJoinTask(node, compatibilityVersions, features, reason, listener)), false, term, null);
    }

    public static JoinTask completingElection(Stream<NodeJoinTask> nodeJoinTaskStream, long term) {
        return new JoinTask(nodeJoinTaskStream.toList(), true, term, null);
    }

    public int nodeCount() {
        return this.nodeJoinTasks.size();
    }

    @Override
    public void onFailure(Exception e) {
        for (NodeJoinTask nodeJoinTask : this.nodeJoinTasks) {
            nodeJoinTask.listener.onFailure(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isBecomingMaster) {
            stringBuilder.append("_FINISH_ELECTION_");
        }
        for (NodeJoinTask nodeJoinTask : this.nodeJoinTasks) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(", ");
            }
            nodeJoinTask.appendDescription(stringBuilder);
        }
        return stringBuilder.toString();
    }

    public Iterable<DiscoveryNode> nodes() {
        return () -> Iterators.map(this.nodeJoinTasks.iterator(), j -> j.node);
    }

    public JoinTask alsoRefreshState(ClusterState latestState) {
        assert (this.isBecomingMaster);
        return new JoinTask(this.nodeJoinTasks, this.isBecomingMaster, this.term, latestState);
    }

    public record NodeJoinTask(DiscoveryNode node, CompatibilityVersions compatibilityVersions, Set<String> features, JoinReason reason, ActionListener<Void> listener) {
        public NodeJoinTask(DiscoveryNode node, CompatibilityVersions compatibilityVersions, Set<String> features, JoinReason reason, ActionListener<Void> listener) {
            this.node = Objects.requireNonNull(node);
            this.compatibilityVersions = Objects.requireNonNull(compatibilityVersions);
            this.features = Objects.requireNonNull(features);
            this.reason = reason;
            this.listener = listener;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendDescription(stringBuilder);
            return stringBuilder.toString();
        }

        public void appendDescription(StringBuilder stringBuilder) {
            this.node.appendDescriptionWithoutAttributes(stringBuilder);
            stringBuilder.append(' ').append(this.reason.message());
        }
    }
}

