/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class StartJoinRequest
extends TransportRequest {
    private final DiscoveryNode masterCandidateNode;
    private final long term;

    public StartJoinRequest(DiscoveryNode masterCandidateNode, long term) {
        this.masterCandidateNode = masterCandidateNode;
        this.term = term;
    }

    public StartJoinRequest(StreamInput input) throws IOException {
        super(input);
        this.masterCandidateNode = new DiscoveryNode(input);
        this.term = input.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.masterCandidateNode.writeTo(out);
        out.writeLong(this.term);
    }

    public DiscoveryNode getMasterCandidateNode() {
        return this.masterCandidateNode;
    }

    public long getTerm() {
        return this.term;
    }

    @Override
    public String toString() {
        return "StartJoinRequest{term=" + this.term + ",node=" + this.masterCandidateNode + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StartJoinRequest)) {
            return false;
        }
        StartJoinRequest that = (StartJoinRequest)o;
        if (this.term != that.term) {
            return false;
        }
        return this.masterCandidateNode.equals(that.masterCandidateNode);
    }

    public int hashCode() {
        int result = this.masterCandidateNode.hashCode();
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        return result;
    }
}

