/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.ClusterApplierRecordingService;
import org.elasticsearch.cluster.service.SourcePrioritizedRunnable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterApplierService
extends AbstractLifecycleComponent
implements ClusterApplier {
    private static final Logger logger = LogManager.getLogger(ClusterApplierService.class);
    public static final Setting<TimeValue> CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING = Setting.positiveTimeSetting("cluster.service.slow_task_logging_threshold", TimeValue.timeValueSeconds((long)30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_SERVICE_SLOW_TASK_THREAD_DUMP_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.service.slow_task_thread_dump_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String CLUSTER_UPDATE_THREAD_NAME = "clusterApplierService#updateTask";
    private final ClusterSettings clusterSettings;
    private final ThreadPool threadPool;
    private volatile TimeValue slowTaskLoggingThreshold;
    private volatile TimeValue slowTaskThreadDumpTimeout;
    private volatile PrioritizedEsThreadPoolExecutor threadPoolExecutor;
    private final Collection<ClusterStateApplier> highPriorityStateAppliers = new CopyOnWriteArrayList<ClusterStateApplier>();
    private final Collection<ClusterStateApplier> normalPriorityStateAppliers = new CopyOnWriteArrayList<ClusterStateApplier>();
    private final Collection<ClusterStateApplier> lowPriorityStateAppliers = new CopyOnWriteArrayList<ClusterStateApplier>();
    private final Collection<ClusterStateListener> clusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Map<TimeoutClusterStateListener, NotifyTimeout> timeoutClusterStateListeners = new ConcurrentHashMap<TimeoutClusterStateListener, NotifyTimeout>();
    private final AtomicReference<ClusterState> state;
    private final String nodeName;
    private final ClusterApplierRecordingService recordingService;
    private NodeConnectionsService nodeConnectionsService;
    @Nullable
    private static final ThreadLocal<Boolean> isApplyingClusterState = Assertions.ENABLED ? new ThreadLocal() : null;

    public ClusterApplierService(String nodeName, Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool) {
        this.clusterSettings = clusterSettings;
        this.threadPool = threadPool;
        this.state = new AtomicReference();
        this.nodeName = nodeName;
        this.recordingService = new ClusterApplierRecordingService();
        clusterSettings.initializeAndWatch(CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING, t -> {
            this.slowTaskLoggingThreshold = t;
        });
        clusterSettings.initializeAndWatch(CLUSTER_SERVICE_SLOW_TASK_THREAD_DUMP_TIMEOUT_SETTING, t -> {
            this.slowTaskThreadDumpTimeout = t;
        });
    }

    public synchronized void setNodeConnectionsService(NodeConnectionsService nodeConnectionsService) {
        assert (this.nodeConnectionsService == null) : "nodeConnectionsService is already set";
        this.nodeConnectionsService = nodeConnectionsService;
    }

    @Override
    public void setInitialState(ClusterState initialState) {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("can't set initial state when started");
        }
        assert (this.state.get() == null) : "state is already set";
        this.state.set(initialState);
    }

    @Override
    protected synchronized void doStart() {
        Objects.requireNonNull(this.nodeConnectionsService, "please set the node connection service before starting");
        Objects.requireNonNull(this.state.get(), "please set initial state before starting");
        this.threadPoolExecutor = this.createThreadPoolExecutor();
    }

    protected PrioritizedEsThreadPoolExecutor createThreadPoolExecutor() {
        return EsExecutors.newSinglePrioritizing(this.nodeName + "/clusterApplierService#updateTask", EsExecutors.daemonThreadFactory(this.nodeName, CLUSTER_UPDATE_THREAD_NAME), this.threadPool.getThreadContext(), this.threadPool.scheduler());
    }

    @Override
    protected synchronized void doStop() {
        for (Map.Entry<TimeoutClusterStateListener, NotifyTimeout> onGoingTimeout : this.timeoutClusterStateListeners.entrySet()) {
            try {
                onGoingTimeout.getValue().cancel();
                onGoingTimeout.getKey().onClose();
            }
            catch (Exception ex) {
                logger.debug("failed to notify listeners on shutdown", (Throwable)ex);
            }
        }
        ThreadPool.terminate(this.threadPoolExecutor, 10L, TimeUnit.SECONDS);
    }

    @Override
    protected synchronized void doClose() {
    }

    public ClusterState state() {
        assert (ClusterApplierService.assertNotCalledFromClusterStateApplier());
        ClusterState clusterState = this.state.get();
        assert (clusterState != null) : "initial cluster state not set yet";
        return clusterState;
    }

    public void addHighPriorityApplier(ClusterStateApplier applier) {
        this.highPriorityStateAppliers.add(applier);
    }

    public void addLowPriorityApplier(ClusterStateApplier applier) {
        this.lowPriorityStateAppliers.add(applier);
    }

    public void addStateApplier(ClusterStateApplier applier) {
        this.normalPriorityStateAppliers.add(applier);
    }

    public void removeApplier(ClusterStateApplier applier) {
        this.normalPriorityStateAppliers.remove(applier);
        this.highPriorityStateAppliers.remove(applier);
        this.lowPriorityStateAppliers.remove(applier);
    }

    public void addListener(ClusterStateListener listener) {
        this.clusterStateListeners.add(listener);
    }

    public void removeListener(ClusterStateListener listener) {
        this.clusterStateListeners.remove(listener);
    }

    public void removeTimeoutListener(TimeoutClusterStateListener listener) {
        NotifyTimeout timeout = this.timeoutClusterStateListeners.remove(listener);
        if (timeout != null) {
            timeout.cancel();
        }
    }

    public void addLocalNodeMasterListener(LocalNodeMasterListener listener) {
        this.addListener(listener);
    }

    public void addTimeoutListener(final @Nullable TimeValue timeout, final TimeoutClusterStateListener listener) {
        if (this.lifecycle.stoppedOrClosed()) {
            listener.onClose();
            return;
        }
        try {
            this.threadPoolExecutor.execute(new SourcePrioritizedRunnable(Priority.HIGH, "_add_listener_"){

                @Override
                public void run() {
                    NotifyTimeout notifyTimeout = new NotifyTimeout(listener, timeout);
                    NotifyTimeout previous = ClusterApplierService.this.timeoutClusterStateListeners.put(listener, notifyTimeout);
                    assert (previous == null) : "Added same listener [" + listener + "]";
                    if (ClusterApplierService.this.lifecycle.stoppedOrClosed()) {
                        listener.onClose();
                        return;
                    }
                    if (timeout != null) {
                        notifyTimeout.cancellable = ClusterApplierService.this.threadPool.schedule(notifyTimeout, timeout, ClusterApplierService.this.threadPool.generic());
                    }
                    listener.postAdded();
                }
            });
        }
        catch (EsRejectedExecutionException e) {
            if (this.lifecycle.stoppedOrClosed()) {
                listener.onClose();
            }
            throw e;
        }
    }

    public void runOnApplierThread(String source, Priority priority, Consumer<ClusterState> clusterStateConsumer, ActionListener<Void> listener) {
        this.submitStateUpdateTask(source, priority, clusterState -> {
            clusterStateConsumer.accept((ClusterState)clusterState);
            return clusterState;
        }, listener);
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public void onNewClusterState(String source, Supplier<ClusterState> clusterStateSupplier, ActionListener<Void> listener) {
        this.submitStateUpdateTask(source, Priority.HIGH, currentState -> {
            ClusterState nextState = (ClusterState)clusterStateSupplier.get();
            if (nextState != null) {
                return nextState;
            }
            return currentState;
        }, listener);
    }

    private void submitStateUpdateTask(String source, Priority priority, Function<ClusterState, ClusterState> clusterStateUpdate, ActionListener<Void> listener) {
        block10: {
            if (!this.lifecycle.started()) {
                return;
            }
            ThreadContext threadContext = this.threadPool.getThreadContext();
            Supplier<ThreadContext.StoredContext> storedContextSupplier = threadContext.newRestorableContext(true);
            try (ThreadContext.StoredContext ignore = threadContext.newEmptySystemContext();){
                this.threadPoolExecutor.execute(new UpdateTask(priority, source, new ClusterApplyActionListener(source, listener, storedContextSupplier), clusterStateUpdate));
            }
            catch (EsRejectedExecutionException e) {
                assert (this.lifecycle.stoppedOrClosed()) : e;
                if (this.lifecycle.stoppedOrClosed()) break block10;
                throw e;
            }
        }
    }

    public static boolean assertNotClusterStateUpdateThread(String reason) {
        assert (!Thread.currentThread().getName().contains(CLUSTER_UPDATE_THREAD_NAME)) : "Expected current thread [" + Thread.currentThread() + "] to not be the cluster state update thread. Reason: [" + reason + "]";
        return true;
    }

    private static boolean assertNotCalledFromClusterStateApplier() {
        if (Thread.currentThread().getName().contains(CLUSTER_UPDATE_THREAD_NAME)) {
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                String className = element.getClassName();
                String methodName = element.getMethodName();
                if (className.equals(ClusterStateObserver.class.getName())) {
                    return true;
                }
                if (className.equals(ClusterApplierService.class.getName()) && methodName.equals("callClusterStateAppliers")) {
                    throw new AssertionError((Object)"On the cluster applier thread you must use ClusterChangedEvent#state() and ClusterChangedEvent#previousState() instead of ClusterApplierService#state(). It is almost certainly a bug to read the latest-applied state from within a cluster applier since the new state has been committed at this point but is not yet applied.");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(String source, Function<ClusterState, ClusterState> updateFunction, ActionListener<Void> clusterApplyListener) {
        ClusterState newClusterState;
        if (!this.lifecycle.started()) {
            logger.debug("processing [{}]: ignoring, cluster applier service not started", (Object)source);
            return;
        }
        logger.debug("processing [{}]: execute", (Object)source);
        ClusterState previousClusterState = this.state.get();
        long startTimeMillis = this.threadPool.relativeTimeInMillis();
        ClusterApplierRecordingService.Recorder stopWatch = new ClusterApplierRecordingService.Recorder(this.threadPool, this.slowTaskThreadDumpTimeout);
        try (Releasable ignored = stopWatch.record("running task [" + source + "]");){
            newClusterState = updateFunction.apply(previousClusterState);
        }
        catch (Exception e) {
            TimeValue executionTime = this.getTimeSince(startTimeMillis);
            logger.trace(() -> Strings.format((String)"failed to execute cluster state applier in [%s], state:\nversion [%s], source [%s]\n%s", (Object[])new Object[]{executionTime, previousClusterState.version(), source, previousClusterState}), (Throwable)e);
            this.warnAboutSlowTaskIfNeeded(executionTime, source, stopWatch);
            clusterApplyListener.onFailure(e);
            return;
        }
        if (previousClusterState == newClusterState) {
            executionTime = this.getTimeSince(startTimeMillis);
            logger.debug("processing [{}]: took [{}] no change in cluster state", (Object)source, (Object)executionTime);
            this.warnAboutSlowTaskIfNeeded(executionTime, source, stopWatch);
            clusterApplyListener.onResponse(null);
        } else {
            if (logger.isTraceEnabled()) {
                logger.debug("cluster state updated, version [{}], source [{}]\n{}", (Object)newClusterState.version(), (Object)source, (Object)newClusterState);
            } else {
                logger.debug("cluster state updated, version [{}], source [{}]", (Object)newClusterState.version(), (Object)source);
            }
            try {
                ClusterApplierService.setIsApplyingClusterState();
                this.applyChanges(previousClusterState, newClusterState, source, stopWatch);
                executionTime = this.getTimeSince(startTimeMillis);
                logger.debug("processing [{}]: took [{}] done applying updated cluster state (version: {}, uuid: {})", (Object)source, (Object)executionTime, (Object)newClusterState.version(), (Object)newClusterState.stateUUID());
                this.warnAboutSlowTaskIfNeeded(executionTime, source, stopWatch);
                clusterApplyListener.onResponse(null);
            }
            catch (Exception e) {
                TimeValue executionTime = this.getTimeSince(startTimeMillis);
                if (logger.isTraceEnabled()) {
                    logger.warn(() -> Strings.format((String)"    failed to apply updated cluster state in [%s]:\n    version [%s], uuid [%s], source [%s]\n    %s\n", (Object[])new Object[]{executionTime, newClusterState.version(), newClusterState.stateUUID(), source, newClusterState}), (Throwable)e);
                } else {
                    logger.warn(() -> Strings.format((String)"failed to apply updated cluster state in [%s]:\nversion [%s], uuid [%s], source [%s]", (Object[])new Object[]{executionTime, newClusterState.version(), newClusterState.stateUUID(), source}), (Throwable)e);
                }
                assert (this.applicationMayFail());
                clusterApplyListener.onFailure(e);
            }
            finally {
                ClusterApplierService.clearIsApplyingClusterState();
            }
        }
    }

    private TimeValue getTimeSince(long startTimeMillis) {
        return TimeValue.timeValueMillis((long)Math.max(0L, this.threadPool.relativeTimeInMillis() - startTimeMillis));
    }

    private void applyChanges(ClusterState previousClusterState, ClusterState newClusterState, String source, ClusterApplierRecordingService.Recorder stopWatch) {
        String summary;
        ClusterChangedEvent clusterChangedEvent = new ClusterChangedEvent(source, newClusterState, previousClusterState);
        DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
        if (nodesDelta.hasChanges() && logger.isInfoEnabled() && (summary = nodesDelta.shortSummary()).length() > 0) {
            logger.info("{}, term: {}, version: {}, reason: {}", (Object)summary, (Object)newClusterState.term(), (Object)newClusterState.version(), (Object)source);
        }
        logger.trace("connecting to nodes of cluster state with version {}", (Object)newClusterState.version());
        try (Releasable ignored = stopWatch.record("connecting to new nodes");){
            this.connectToNodesAndWait(newClusterState);
        }
        if (!clusterChangedEvent.state().blocks().disableStatePersistence() && clusterChangedEvent.metadataChanged()) {
            logger.debug("applying settings from cluster state with version {}", (Object)newClusterState.version());
            Settings incomingSettings = clusterChangedEvent.state().metadata().settings();
            try (Releasable ignored = stopWatch.record("applying settings");){
                this.clusterSettings.applySettings(incomingSettings);
            }
        }
        logger.debug("apply cluster state with version {}", (Object)newClusterState.version());
        this.callClusterStateAppliers(clusterChangedEvent, stopWatch);
        this.nodeConnectionsService.disconnectFromNodesExcept(newClusterState.nodes());
        logger.debug("set locally applied cluster state to version {}", (Object)newClusterState.version());
        this.state.set(newClusterState);
        this.callClusterStateListeners(clusterChangedEvent, stopWatch);
    }

    protected void connectToNodesAndWait(ClusterState newClusterState) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.connectToNodesAsync(newClusterState, countDownLatch::countDown);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            logger.debug("interrupted while connecting to nodes, continuing", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    protected final void connectToNodesAsync(ClusterState newClusterState, Runnable onCompletion) {
        this.nodeConnectionsService.connectToNodes(newClusterState.nodes(), onCompletion);
    }

    private void callClusterStateAppliers(ClusterChangedEvent clusterChangedEvent, ClusterApplierRecordingService.Recorder stopWatch) {
        ClusterApplierService.callClusterStateAppliers(clusterChangedEvent, stopWatch, this.highPriorityStateAppliers);
        ClusterApplierService.callClusterStateAppliers(clusterChangedEvent, stopWatch, this.normalPriorityStateAppliers);
        ClusterApplierService.callClusterStateAppliers(clusterChangedEvent, stopWatch, this.lowPriorityStateAppliers);
    }

    private static void callClusterStateAppliers(ClusterChangedEvent clusterChangedEvent, ClusterApplierRecordingService.Recorder stopWatch, Collection<ClusterStateApplier> clusterStateAppliers) {
        for (ClusterStateApplier applier : clusterStateAppliers) {
            logger.trace("calling [{}] with change to version [{}]", (Object)applier, (Object)clusterChangedEvent.state().version());
            String name = applier.toString();
            Releasable ignored = stopWatch.record(name);
            try {
                applier.applyClusterState(clusterChangedEvent);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
    }

    private void callClusterStateListeners(ClusterChangedEvent clusterChangedEvent, ClusterApplierRecordingService.Recorder stopWatch) {
        ClusterApplierService.callClusterStateListener(clusterChangedEvent, stopWatch, this.clusterStateListeners);
        ClusterApplierService.callClusterStateListener(clusterChangedEvent, stopWatch, this.timeoutClusterStateListeners.keySet());
    }

    private static void callClusterStateListener(ClusterChangedEvent clusterChangedEvent, ClusterApplierRecordingService.Recorder stopWatch, Collection<? extends ClusterStateListener> listeners) {
        for (ClusterStateListener clusterStateListener : listeners) {
            try {
                logger.trace("calling [{}] with change to version [{}]", (Object)clusterStateListener, (Object)clusterChangedEvent.state().version());
                String name = clusterStateListener.toString();
                Releasable ignored = stopWatch.record(name);
                try {
                    clusterStateListener.clusterChanged(clusterChangedEvent);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception ex) {
                logger.warn("failed to notify ClusterStateListener", (Throwable)ex);
            }
        }
    }

    private void warnAboutSlowTaskIfNeeded(TimeValue executionTime, String source, ClusterApplierRecordingService.Recorder recorder) {
        if (executionTime.getMillis() > this.slowTaskLoggingThreshold.getMillis()) {
            logger.warn("cluster state applier task [{}] took [{}] which is above the warn threshold of [{}]: {}", (Object)source, (Object)executionTime, (Object)this.slowTaskLoggingThreshold, (Object)recorder.getRecordings().stream().map(ti -> "[" + (String)ti.v1() + "] took [" + ti.v2() + "ms]").collect(Collectors.joining(", ")));
        }
        this.recordingService.updateStats(recorder);
    }

    protected boolean applicationMayFail() {
        return false;
    }

    @Override
    public ClusterApplierRecordingService.Stats getStats() {
        return this.recordingService.getStats();
    }

    public int getTimeoutClusterStateListenersSize() {
        return this.timeoutClusterStateListeners.size();
    }

    public static boolean assertNotApplyingClusterState() {
        assert (isApplyingClusterState == null || isApplyingClusterState.get() == null) : "operation not permitted while applying cluster state, currently on thread " + Thread.currentThread().getName();
        return true;
    }

    public static void setIsApplyingClusterState() {
        assert (ThreadPool.assertCurrentThreadPool(CLUSTER_UPDATE_THREAD_NAME));
        if (isApplyingClusterState != null) {
            isApplyingClusterState.set(Boolean.TRUE);
        }
    }

    public static void clearIsApplyingClusterState() {
        assert (ThreadPool.assertCurrentThreadPool(CLUSTER_UPDATE_THREAD_NAME));
        if (isApplyingClusterState != null) {
            isApplyingClusterState.remove();
        }
    }

    private class NotifyTimeout
    implements Runnable {
        final TimeoutClusterStateListener listener;
        @Nullable
        final TimeValue timeout;
        volatile Scheduler.Cancellable cancellable;

        NotifyTimeout(@Nullable TimeoutClusterStateListener listener, TimeValue timeout) {
            this.listener = listener;
            this.timeout = timeout;
        }

        public void cancel() {
            if (this.cancellable != null) {
                this.cancellable.cancel();
            }
        }

        @Override
        public void run() {
            assert (this.timeout != null) : "This should only ever execute if there's an actual timeout set";
            if (this.cancellable != null && this.cancellable.isCancelled()) {
                return;
            }
            if (ClusterApplierService.this.lifecycle.stoppedOrClosed()) {
                this.listener.onClose();
            } else {
                this.listener.onTimeout(this.timeout);
            }
        }
    }

    class UpdateTask
    extends SourcePrioritizedRunnable {
        private final ActionListener<Void> listener;
        private final Function<ClusterState, ClusterState> updateFunction;

        UpdateTask(Priority priority, String source, ActionListener<Void> listener, Function<ClusterState, ClusterState> updateFunction) {
            super(priority, source);
            this.listener = listener;
            this.updateFunction = updateFunction;
        }

        @Override
        public void run() {
            ClusterApplierService.this.runTask(this.source(), this.updateFunction, this.listener);
        }
    }

    private static class ClusterApplyActionListener
    implements ActionListener<Void> {
        private final String source;
        private final ActionListener<Void> listener;
        private final Supplier<ThreadContext.StoredContext> storedContextSupplier;

        ClusterApplyActionListener(String source, ActionListener<Void> listener, Supplier<ThreadContext.StoredContext> storedContextSupplier) {
            this.source = source;
            this.listener = listener;
            this.storedContextSupplier = storedContextSupplier;
        }

        @Override
        public void onFailure(Exception e) {
            try (ThreadContext.StoredContext ignored = this.storedContextSupplier.get();){
                this.listener.onFailure(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                assert (false) : inner;
                logger.error(() -> "exception thrown by listener notifying of failure from [" + this.source + "]", (Throwable)inner);
            }
        }

        @Override
        public void onResponse(Void unused) {
            try (ThreadContext.StoredContext ignored = this.storedContextSupplier.get();){
                this.listener.onResponse(null);
            }
            catch (Exception e) {
                assert (false) : e;
                logger.error(() -> "exception thrown by listener while notifying of cluster state processed from [" + this.source + "]", (Throwable)e);
            }
        }
    }
}

