/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.lucene.util.SetOnce;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.PropertyPlaceholder;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.StringLiteralDeduplicator;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class Settings
implements ToXContentFragment,
Writeable,
Diffable<Settings> {
    public static final Settings EMPTY = new Settings(Map.of(), null);
    public static final String FLAT_SETTINGS_PARAM = "flat_settings";
    public static final ToXContent.MapParams FLAT_SETTINGS_TRUE = new ToXContent.MapParams(Map.of("flat_settings", "true"));
    private final NavigableMap<String, Object> settings;
    private final SecureSettings secureSettings;
    private Set<String> firstLevelNames;
    private Set<String> keys;
    private static final DiffableUtils.ValueSerializer<String, Object> DIFF_VALUE_SERIALIZER = new DiffableUtils.NonDiffableValueSerializer<String, Object>(){

        @Override
        public void write(Object value, StreamOutput out) throws IOException {
            Settings.writeSettingValue(out, value);
        }

        @Override
        public Object read(StreamInput in, String key) throws IOException {
            return in.readGenericValue();
        }
    };
    public static final Set<String> FORMAT_PARAMS = Set.of("settings_filter", "flat_settings");
    private static final StringLiteralDeduplicator settingLiteralDeduplicator = new StringLiteralDeduplicator();

    private static Settings of(Map<String, Object> settings, SecureSettings secureSettings) {
        if (secureSettings == null && settings.isEmpty()) {
            return EMPTY;
        }
        return new Settings(settings, secureSettings);
    }

    private Settings(Map<String, Object> settings, SecureSettings secureSettings) {
        TreeMap<String, List<String>> tree = new TreeMap<String, List<String>>();
        for (Map.Entry<String, Object> settingEntry : settings.entrySet()) {
            List<String> internedValue;
            Object value = settingEntry.getValue();
            if (value instanceof String) {
                internedValue = Settings.internKeyOrValue((String)value);
            } else if (value instanceof List) {
                List valueList = (List)value;
                int listSize = valueList.size();
                String[] internedArr = new String[listSize];
                for (int i = 0; i < valueList.size(); ++i) {
                    internedArr[i] = Settings.internKeyOrValue((String)valueList.get(i));
                }
                internedValue = List.of(internedArr);
            } else {
                internedValue = value;
            }
            tree.put(Settings.internKeyOrValue(settingEntry.getKey()), internedValue);
        }
        this.settings = Collections.unmodifiableNavigableMap(tree);
        this.secureSettings = secureSettings;
    }

    SecureSettings getSecureSettings() {
        return this.secureSettings;
    }

    private Map<String, Object> getAsStructuredMap() {
        Map<String, Object> map = Maps.newMapWithExpectedSize(2);
        for (Map.Entry entry : this.settings.entrySet()) {
            Settings.processSetting(map, "", (String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(Settings.convertMapsToArrays(valMap));
        }
        return map;
    }

    private static void processSetting(Map<String, Object> map, String prefix, String setting, Object value) {
        int prefixLength = setting.indexOf(46);
        if (prefixLength == -1) {
            Map innerMap = (Map)map.get(prefix + setting);
            if (innerMap != null) {
                for (Map.Entry entry : innerMap.entrySet()) {
                    map.put(prefix + setting + "." + (String)entry.getKey(), entry.getValue());
                }
            }
            map.put(prefix + setting, value);
        } else {
            String key = setting.substring(0, prefixLength);
            String rest = setting.substring(prefixLength + 1);
            Object existingValue = map.get(prefix + key);
            if (existingValue == null) {
                Map<String, Object> newMap = Maps.newMapWithExpectedSize(2);
                Settings.processSetting(newMap, "", rest, value);
                map.put(prefix + key, newMap);
            } else if (existingValue instanceof Map) {
                Map innerMap = (Map)existingValue;
                Settings.processSetting(innerMap, "", rest, value);
                map.put(prefix + key, innerMap);
            } else {
                Settings.processSetting(map, prefix + key + ".", rest, value);
            }
        }
    }

    private static Object convertMapsToArrays(Map<String, Object> map) {
        if (map.isEmpty()) {
            return map;
        }
        boolean isArray = true;
        int maxIndex = -1;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (isArray) {
                try {
                    int index;
                    String key = entry.getKey();
                    int n = index = Numbers.isPositiveNumeric(key) ? Integer.parseInt(key) : -1;
                    if (index >= 0) {
                        maxIndex = Math.max(maxIndex, index);
                    } else {
                        isArray = false;
                    }
                }
                catch (NumberFormatException ex) {
                    isArray = false;
                }
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(Settings.convertMapsToArrays(valMap));
        }
        if (isArray && maxIndex + 1 == map.size()) {
            ArrayList<Object> newValue = new ArrayList<Object>(maxIndex + 1);
            for (int i = 0; i <= maxIndex; ++i) {
                Object obj = map.get(Integer.toString(i));
                if (obj == null) {
                    return map;
                }
                newValue.add(obj);
            }
            return newValue;
        }
        return map;
    }

    public Settings getByPrefix(String prefix) {
        if (prefix.isEmpty()) {
            return this;
        }
        char[] toPrefixCharArr = prefix.toCharArray();
        int n = toPrefixCharArr.length - 1;
        toPrefixCharArr[n] = (char)(toPrefixCharArr[n] + '\u0001');
        String toPrefix = new String(toPrefixCharArr);
        SortedMap<String, Object> subMap = this.settings.subMap(prefix, toPrefix);
        return Settings.of(subMap.isEmpty() ? Map.of() : new FilteredMap(subMap, null, prefix), this.secureSettings == null ? null : new PrefixedSecureSettings(this.secureSettings, prefix, s -> s.startsWith(prefix)));
    }

    public Settings filter(Predicate<String> predicate) {
        return Settings.of(new FilteredMap(this.settings, predicate, null), this.secureSettings == null ? null : new PrefixedSecureSettings(this.secureSettings, "", predicate));
    }

    public Settings getAsSettings(String setting) {
        return this.getByPrefix(setting + ".");
    }

    public String get(String setting) {
        return Settings.toString(this.settings.get(setting));
    }

    public String get(String setting, String defaultValue) {
        String retVal = this.get(setting);
        return retVal == null ? defaultValue : retVal;
    }

    public Float getAsFloat(String setting, Float defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Double getAsDouble(String setting, Double defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Integer getAsInt(String setting, Integer defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Long getAsLong(String setting, Long defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public boolean hasValue(String key) {
        return this.settings.get(key) != null;
    }

    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        return Booleans.parseBoolean((String)this.get(setting), (Boolean)defaultValue);
    }

    public TimeValue getAsTime(String setting, TimeValue defaultValue) {
        return TimeValue.parseTimeValue((String)this.get(setting), (TimeValue)defaultValue, (String)setting);
    }

    public ByteSizeValue getAsBytesSize(String setting, ByteSizeValue defaultValue) throws SettingsException {
        return ByteSizeValue.parseBytesSizeValue(this.get(setting), defaultValue, setting);
    }

    public ByteSizeValue getAsMemory(String setting, String defaultValue) throws SettingsException {
        return MemorySizeValue.parseBytesSizeValueOrHeapRatio(this.get(setting, defaultValue), setting);
    }

    public List<String> getAsList(String key) throws SettingsException {
        return this.getAsList(key, Collections.emptyList());
    }

    public List<String> getAsList(String key, List<String> defaultValue) throws SettingsException {
        return this.getAsList(key, defaultValue, true);
    }

    public List<String> getAsList(String key, List<String> defaultValue, Boolean commaDelimited) throws SettingsException {
        ArrayList<String> result = new ArrayList<String>();
        Object valueFromPrefix = this.settings.get(key);
        if (valueFromPrefix != null) {
            if (valueFromPrefix instanceof List) {
                List valuesAsList = (List)valueFromPrefix;
                return valuesAsList;
            }
            if (commaDelimited.booleanValue()) {
                String value = this.get(key);
                String[] strings = Strings.splitStringByCommaToArray(value);
                if (strings.length > 0) {
                    for (String string : strings) {
                        result.add(string.trim());
                    }
                }
            } else {
                result.add(this.get(key).trim());
            }
        }
        if (result.isEmpty()) {
            return defaultValue;
        }
        return Collections.unmodifiableList(result);
    }

    public Map<String, Settings> getGroups(String settingPrefix) throws SettingsException {
        return this.getGroups(settingPrefix, false);
    }

    public Map<String, Settings> getGroups(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        if (!Strings.hasLength((String)settingPrefix)) {
            throw new IllegalArgumentException("illegal setting prefix " + (String)settingPrefix);
        }
        if (((String)settingPrefix).charAt(((String)settingPrefix).length() - 1) != '.') {
            settingPrefix = (String)settingPrefix + ".";
        }
        return this.getGroupsInternal((String)settingPrefix, ignoreNonGrouped);
    }

    private Map<String, Settings> getGroupsInternal(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        Settings prefixSettings = this.getByPrefix(settingPrefix);
        if (prefixSettings.isEmpty()) {
            return Map.of();
        }
        HashMap<String, Settings> groups = new HashMap<String, Settings>();
        for (String groupName : prefixSettings.names()) {
            Settings groupSettings = prefixSettings.getByPrefix(groupName + ".");
            if (groupSettings.isEmpty()) {
                if (ignoreNonGrouped) continue;
                throw new SettingsException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + settingPrefix + groupName + "] because of a missing '.'");
            }
            groups.put(groupName, groupSettings);
        }
        return Collections.unmodifiableMap(groups);
    }

    public Map<String, Settings> getAsGroups() throws SettingsException {
        return this.getGroupsInternal("", false);
    }

    public <T extends VersionId<T>> T getAsVersionId(String setting, IntFunction<T> parseVersion) throws SettingsException {
        return this.getAsVersionId(setting, parseVersion, null);
    }

    public <T extends VersionId<T>> T getAsVersionId(String setting, IntFunction<T> parseVersion, T defaultVersion) throws SettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultVersion;
        }
        try {
            return (T)((VersionId)parseVersion.apply(Integer.parseInt(sValue)));
        }
        catch (Exception e) {
            throw new SettingsException("Failed to parse version setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Set<String> names() {
        Set<String> names = this.firstLevelNames;
        if (names != null) {
            return names;
        }
        Stream stream = this.settings.keySet().stream();
        if (this.secureSettings != null) {
            stream = Stream.concat(stream, this.secureSettings.getSettingNames().stream());
        }
        Set<String> newFirstLevelNames = stream.map(k -> {
            int i = k.indexOf(46);
            if (i < 0) {
                return k;
            }
            return k.substring(0, i);
        }).collect(Collectors.toUnmodifiableSet());
        this.firstLevelNames = newFirstLevelNames;
        return newFirstLevelNames;
    }

    public String toDelimitedString(char delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.settings.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append(entry.getValue()).append(delimiter);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings that = (Settings)o;
        return Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return this.settings != null ? this.settings.hashCode() : 0;
    }

    public static Settings readSettingsFromStream(StreamInput in) throws IOException {
        int numberOfSettings = in.readVInt();
        if (numberOfSettings == 0) {
            return EMPTY;
        }
        Builder builder = new Builder();
        for (int i = 0; i < numberOfSettings; ++i) {
            String key = in.readString();
            Object value = in.readGenericValue();
            if (value == null) {
                builder.putNull(key);
                continue;
            }
            if (value instanceof List) {
                List stringList = (List)value;
                builder.putList(key, stringList);
                continue;
            }
            builder.put(key, value.toString());
        }
        return builder.build();
    }

    public static Diff<Settings> readSettingsDiffFromStream(StreamInput in) throws IOException {
        return new SettingsDiff(DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), DIFF_VALUE_SERIALIZER));
    }

    @Override
    public Diff<Settings> diff(Settings previousState) {
        DiffableUtils.MapDiff<String, Object, Map<String, Object>> mapDiff = DiffableUtils.diff(previousState.settings, this.settings, DiffableUtils.getStringKeySerializer(), DIFF_VALUE_SERIALIZER);
        return new SettingsDiff(mapDiff);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.settings, Settings::writeSettingValue);
    }

    private static void writeSettingValue(StreamOutput streamOutput, Object value) throws IOException {
        if (value instanceof String) {
            streamOutput.writeGenericString((String)value);
        } else if (value instanceof List) {
            List stringList = (List)value;
            streamOutput.writeGenericList(stringList, StreamOutput::writeGenericString);
        } else {
            assert (value == null) : "unexpected value [" + value + "]";
            streamOutput.writeGenericNull();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Settings settings = SettingsFilter.filterSettings(params, this);
        if (!params.paramAsBoolean(FLAT_SETTINGS_PARAM, false)) {
            Settings.toXContentFlat(builder, settings);
        } else {
            Settings.toXContent(builder, settings);
        }
        return builder;
    }

    private static void toXContent(XContentBuilder builder, Settings settings) throws IOException {
        for (Map.Entry entry : settings.settings.entrySet()) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value instanceof String) {
                builder.field(key, (String)value);
                continue;
            }
            if (value instanceof List) {
                builder.stringListField(key, (Collection)((List)value));
                continue;
            }
            builder.field(key, value);
        }
    }

    private static void toXContentFlat(XContentBuilder builder, Settings settings) throws IOException {
        for (Map.Entry<String, Object> entry : settings.getAsStructuredMap().entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (value instanceof String) {
                builder.field(key, (String)value);
                continue;
            }
            if (value instanceof Map) {
                builder.field(key).map((Map)value);
                continue;
            }
            builder.field(key, value);
        }
    }

    public static Settings fromXContent(XContentParser parser) throws IOException {
        return Settings.fromXContent(parser, true, false);
    }

    private static Settings fromXContent(XContentParser parser, boolean allowNullValues, boolean validateEndOfStream) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        Builder innerBuilder = Settings.builder();
        StringBuilder currentKeyBuilder = new StringBuilder();
        Settings.fromXContent(parser, currentKeyBuilder, innerBuilder, allowNullValues);
        if (validateEndOfStream) {
            XContentParser.Token lastToken = null;
            try {
                while (!parser.isClosed() && (lastToken = parser.nextToken()) == null) {
                }
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("malformed, expected end of settings but encountered additional content starting at line number: [{}], column number: [{}]", (Throwable)e, parser.getTokenLocation().lineNumber(), parser.getTokenLocation().columnNumber());
            }
            if (lastToken != null) {
                throw new ElasticsearchParseException("malformed, expected end of settings but encountered additional content starting at line number: [{}], column number: [{}]", parser.getTokenLocation().lineNumber(), parser.getTokenLocation().columnNumber());
            }
        }
        return innerBuilder.build();
    }

    private static void fromXContent(XContentParser parser, StringBuilder keyBuilder, Builder builder, boolean allowNullValues) throws IOException {
        String currentFieldName;
        int length = keyBuilder.length();
        block10: while ((currentFieldName = parser.nextFieldName()) != null) {
            keyBuilder.setLength(length);
            keyBuilder.append(currentFieldName);
            XContentParser.Token token = parser.nextToken();
            switch (token) {
                case START_OBJECT: {
                    keyBuilder.append('.');
                    Settings.fromXContent(parser, keyBuilder, builder, allowNullValues);
                    continue block10;
                }
                case START_ARRAY: {
                    ArrayList<String> list = new ArrayList<String>();
                    block11: while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        switch (token) {
                            case VALUE_STRING: 
                            case VALUE_NUMBER: 
                            case VALUE_BOOLEAN: {
                                list.add(parser.text());
                                continue block11;
                            }
                        }
                        throw new IllegalStateException("only value lists are allowed in serialized settings");
                    }
                    String key = keyBuilder.toString();
                    Settings.validateValue(key, list, parser, allowNullValues);
                    builder.putList(key, list);
                    continue block10;
                }
                case VALUE_NULL: {
                    String key = keyBuilder.toString();
                    Settings.validateValue(key, null, parser, allowNullValues);
                    builder.putNull(key);
                    continue block10;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    String key = keyBuilder.toString();
                    String value = parser.text();
                    Settings.validateValue(key, value, parser, allowNullValues);
                    builder.put(key, value);
                    continue block10;
                }
                case VALUE_BOOLEAN: {
                    String key = keyBuilder.toString();
                    Settings.validateValue(key, parser.text(), parser, allowNullValues);
                    builder.put(key, parser.booleanValue());
                    continue block10;
                }
            }
            XContentParserUtils.throwUnknownToken(parser.currentToken(), parser);
        }
    }

    private static void validateValue(String key, Object currentValue, XContentParser parser, boolean allowNullValues) {
        if (currentValue == null && !allowNullValues) {
            throw new ElasticsearchParseException("null-valued setting found for key [{}] found at line number [{}], column number [{}]", key, parser.getTokenLocation().lineNumber(), parser.getTokenLocation().columnNumber());
        }
    }

    public boolean isEmpty() {
        return this.settings.isEmpty() && (this.secureSettings == null || this.secureSettings.getSettingNames().isEmpty());
    }

    public int size() {
        return this.keySet().size();
    }

    public Set<String> keySet() {
        Set<String> newKeySet;
        Set<String> keySet = this.keys;
        if (keySet != null) {
            return keySet;
        }
        if (this.secureSettings == null) {
            newKeySet = Set.copyOf(this.settings.keySet());
        } else {
            HashSet merged = new HashSet(this.settings.keySet());
            merged.addAll(this.secureSettings.getSettingNames());
            newKeySet = Set.copyOf(merged);
        }
        this.keys = newKeySet;
        return newKeySet;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (ToXContent.Params)FLAT_SETTINGS_TRUE);
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public static String internKeyOrValue(String s) {
        return settingLiteralDeduplicator.deduplicate(s);
    }

    private static final class FilteredMap
    extends AbstractMap<String, Object> {
        private final Map<String, Object> delegate;
        @Nullable
        private final Predicate<String> filter;
        @Nullable
        private final String prefix;
        private int size;

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            final Set<Map.Entry<String, Object>> delegateSet = this.delegate.entrySet();
            AbstractSet<Map.Entry<String, Object>> filterSet = new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    final Iterator iter = delegateSet.iterator();
                    return new Iterator<Map.Entry<String, Object>>(){
                        private int numIterated;
                        private Map.Entry<String, Object> currentElement;

                        @Override
                        public boolean hasNext() {
                            if (this.currentElement != null) {
                                return true;
                            }
                            if (this.numIterated == size) {
                                assert (size != -1) : "size was never set: " + this.numIterated + " vs. " + size;
                                return false;
                            }
                            while (iter.hasNext()) {
                                this.currentElement = (Map.Entry)iter.next();
                                if (!this.test((String)this.currentElement.getKey())) continue;
                                ++this.numIterated;
                                return true;
                            }
                            this.currentElement = null;
                            return false;
                        }

                        @Override
                        public Map.Entry<String, Object> next() {
                            if (this.currentElement == null && !this.hasNext()) {
                                throw new NoSuchElementException("make sure to call hasNext first");
                            }
                            final Map.Entry<String, Object> current = this.currentElement;
                            this.currentElement = null;
                            if (prefix == null) {
                                return current;
                            }
                            return new Map.Entry<String, Object>(){

                                @Override
                                public String getKey() {
                                    return ((String)current.getKey()).substring(prefix.length());
                                }

                                @Override
                                public Object getValue() {
                                    return current.getValue();
                                }

                                @Override
                                public Object setValue(Object value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                    };
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
            return filterSet;
        }

        private FilteredMap(Map<String, Object> delegate, Predicate<String> filter, String prefix) {
            this.delegate = delegate;
            this.filter = filter;
            this.prefix = prefix;
            this.size = filter == null ? delegate.size() : -1;
        }

        @Override
        public Object get(Object key) {
            if (key instanceof String) {
                String theKey;
                String string = theKey = this.prefix == null ? (String)key : this.prefix + key;
                if (this.test(theKey)) {
                    return this.delegate.get(theKey);
                }
            }
            return null;
        }

        private boolean test(String theKey) {
            return this.filter == null || this.filter.test(theKey);
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                String theKey;
                String string = theKey = this.prefix == null ? (String)key : this.prefix + key;
                if (this.test(theKey)) {
                    return this.delegate.containsKey(theKey);
                }
            }
            return false;
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = Math.toIntExact(this.delegate.keySet().stream().filter(this.filter).count());
            }
            return this.size;
        }
    }

    private static class PrefixedSecureSettings
    implements SecureSettings {
        private final SecureSettings delegate;
        private final UnaryOperator<String> addPrefix;
        private final UnaryOperator<String> removePrefix;
        private final Predicate<String> keyPredicate;
        private final SetOnce<Set<String>> settingNames = new SetOnce();

        PrefixedSecureSettings(SecureSettings delegate, String prefix, Predicate<String> keyPredicate) {
            this.delegate = delegate;
            this.addPrefix = s -> prefix + s;
            this.removePrefix = s -> s.substring(prefix.length());
            this.keyPredicate = keyPredicate;
        }

        @Override
        public boolean isLoaded() {
            return this.delegate.isLoaded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> getSettingNames() {
            SetOnce<Set<String>> setOnce = this.settingNames;
            synchronized (setOnce) {
                if (this.settingNames.get() == null) {
                    Set names = this.delegate.getSettingNames().stream().filter(this.keyPredicate).map(this.removePrefix).collect(Collectors.toSet());
                    this.settingNames.set(Collections.unmodifiableSet(names));
                }
            }
            return (Set)this.settingNames.get();
        }

        @Override
        public SecureString getString(String setting) {
            return this.delegate.getString((String)this.addPrefix.apply(setting));
        }

        @Override
        public InputStream getFile(String setting) throws GeneralSecurityException {
            return this.delegate.getFile((String)this.addPrefix.apply(setting));
        }

        @Override
        public byte[] getSHA256Digest(String setting) throws GeneralSecurityException {
            return this.delegate.getSHA256Digest((String)this.addPrefix.apply(setting));
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            throw new IllegalStateException("Unsupported operation");
        }
    }

    public static class Builder {
        private final Map<String, Object> map = new TreeMap<String, Object>();
        private final SetOnce<SecureSettings> secureSettings = new SetOnce();

        private Builder() {
        }

        public Set<String> keys() {
            return this.map.keySet();
        }

        public String remove(String key) {
            return Settings.toString(this.map.remove(key));
        }

        public String get(String key) {
            return Settings.toString(this.map.get(key));
        }

        public SecureSettings getSecureSettings() {
            return (SecureSettings)this.secureSettings.get();
        }

        public Builder setSecureSettings(SecureSettings secureSettings) {
            if (!secureSettings.isLoaded()) {
                throw new IllegalStateException("Secure settings must already be loaded");
            }
            if (this.secureSettings.get() != null) {
                throw new IllegalArgumentException("Secure settings already set. Existing settings: " + ((SecureSettings)this.secureSettings.get()).getSettingNames() + ", new settings: " + secureSettings.getSettingNames());
            }
            this.secureSettings.set((Object)secureSettings);
            return this;
        }

        public Builder put(String key, Path path) {
            return this.put(key, path.toString());
        }

        public Builder put(String key, TimeValue timeValue) {
            return this.put(key, timeValue.getStringRep());
        }

        public Builder put(String key, ByteSizeValue byteSizeValue) {
            return this.put(key, byteSizeValue.getStringRep());
        }

        public Builder put(String key, Enum<?> enumValue) {
            return this.put(key, enumValue.toString());
        }

        public Builder put(String key, Level level) {
            return this.put(key, level.toString());
        }

        public Builder put(String key, Version luceneVersion) {
            return this.put(key, luceneVersion.toString());
        }

        public Builder put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder copy(String key, Settings source) {
            return this.copy(key, key, source);
        }

        public Builder copy(String key, String sourceKey, Settings source) {
            if (!source.settings.containsKey(sourceKey)) {
                throw new IllegalArgumentException("source key not found in the source settings");
            }
            Object value = source.settings.get(sourceKey);
            if (value instanceof List) {
                List stringList = (List)value;
                return this.putList(key, stringList);
            }
            if (value == null) {
                return this.putNull(key);
            }
            return this.put(key, Settings.toString(value));
        }

        public Builder putNull(String key) {
            return this.put(key, (String)null);
        }

        public Builder put(String setting, boolean value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, int value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, VersionId<?> version) {
            this.put(setting, version.id());
            return this;
        }

        public Builder put(String setting, long value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, float value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, double value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, long value, TimeUnit timeUnit) {
            this.put(setting, new TimeValue(value, timeUnit));
            return this;
        }

        public Builder put(String setting, long value, ByteSizeUnit sizeUnit) {
            this.put(setting, sizeUnit.toBytes(value) + "b");
            return this;
        }

        public Builder putList(String setting, String ... values) {
            return this.putList(setting, Arrays.asList(values));
        }

        public Builder putList(String setting, List<String> values) {
            this.remove(setting);
            this.map.put(setting, new ArrayList<String>(values));
            return this;
        }

        public Builder put(Settings settings) {
            return this.put(settings, true);
        }

        public Builder put(Settings settings, boolean copySecureSettings) {
            HashMap<String, Object> settingsMap = new HashMap<String, Object>(settings.settings);
            this.processLegacyLists(settingsMap);
            this.map.putAll(settingsMap);
            if (copySecureSettings && settings.getSecureSettings() != null) {
                this.setSecureSettings(settings.getSecureSettings());
            }
            return this;
        }

        private void processLegacyLists(Map<String, Object> map) {
            block0: for (String key : (String[])map.keySet().toArray(String[]::new)) {
                if (!key.endsWith(".0")) continue;
                int counter = 0;
                String prefix = key.substring(0, key.lastIndexOf(46));
                if (map.containsKey(prefix)) {
                    throw new IllegalStateException("settings builder can't contain values for [" + prefix + "=" + map.get(prefix) + "] and [" + key + "=" + map.get(key) + "]");
                }
                ArrayList<String> values = new ArrayList<String>();
                while (true) {
                    String listKey;
                    String value;
                    if ((value = this.get(listKey = prefix + "." + counter++)) == null) {
                        map.put(prefix, values);
                        continue block0;
                    }
                    values.add(value);
                    map.remove(listKey);
                }
            }
        }

        public Builder loadFromMap(Map<String, ?> map) {
            Builder builder;
            block8: {
                XContentBuilder builder2 = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
                try {
                    builder2.map(map);
                    builder = this.loadFromSource(Strings.toString(builder2), builder2.contentType());
                    if (builder2 == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (builder2 != null) {
                            try {
                                builder2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ElasticsearchGenerationException("Failed to generate [" + map + "]", e);
                    }
                }
                builder2.close();
            }
            return builder;
        }

        public Builder loadFromSource(String source, XContentType xContentType) {
            try (XContentParser parser = XContentFactory.xContent((XContentType)xContentType).createParser(XContentParserConfiguration.EMPTY, source);){
                this.put(Settings.fromXContent(parser, true, true));
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + source + "]", e);
            }
            return this;
        }

        public Builder loadFromPath(Path path) throws IOException {
            return this.loadFromStream(path.getFileName().toString(), Files.newInputStream(path, new OpenOption[0]), false);
        }

        public Builder loadFromStream(String resourceName, InputStream is, boolean acceptNullValues) throws IOException {
            XContentType xContentType;
            if (resourceName.endsWith(".json")) {
                xContentType = XContentType.JSON;
            } else if (resourceName.endsWith(".yml") || resourceName.endsWith(".yaml")) {
                xContentType = XContentType.YAML;
            } else {
                throw new IllegalArgumentException("unable to detect content type from resource name [" + resourceName + "]");
            }
            try (XContentParser parser = XContentFactory.xContent((XContentType)xContentType).createParser(XContentParserConfiguration.EMPTY, is);){
                if (parser.currentToken() == null && parser.nextToken() == null) {
                    Builder builder = this;
                    return builder;
                }
                this.put(Settings.fromXContent(parser, acceptNullValues, true));
            }
            catch (ElasticsearchParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + resourceName + "]", e);
            }
            finally {
                IOUtils.close((Closeable)is);
            }
            return this;
        }

        public Builder putProperties(Map<String, String> esSettings, Function<String, String> keyFunction) {
            for (Map.Entry<String, String> esSetting : esSettings.entrySet()) {
                String key = esSetting.getKey();
                this.put(keyFunction.apply(key), esSetting.getValue());
            }
            return this;
        }

        public Builder replacePropertyPlaceholders() {
            PropertyPlaceholder propertyPlaceholder = new PropertyPlaceholder("${", "}", false);
            PropertyPlaceholder.PlaceholderResolver placeholderResolver = new PropertyPlaceholder.PlaceholderResolver(){

                @Override
                public String resolvePlaceholder(String placeholderName) {
                    return Settings.toString(map.get(placeholderName));
                }

                @Override
                public boolean shouldIgnoreMissing(String placeholderName) {
                    return placeholderName.startsWith("prompt.");
                }

                @Override
                public boolean shouldRemoveMissingPlaceholder(String placeholderName) {
                    return !placeholderName.startsWith("prompt.");
                }
            };
            Iterator<Map.Entry<String, Object>> entryItr = this.map.entrySet().iterator();
            while (entryItr.hasNext()) {
                Map.Entry<String, Object> entry = entryItr.next();
                if (entry.getValue() == null) continue;
                if (entry.getValue() instanceof List) {
                    ArrayList mutableList = new ArrayList((List)entry.getValue());
                    ListIterator<String> li = mutableList.listIterator();
                    boolean changed = false;
                    while (li.hasNext()) {
                        String settingValueRaw = (String)li.next();
                        String settingValueResolved = propertyPlaceholder.replacePlaceholders(settingValueRaw, placeholderResolver);
                        if (settingValueResolved.equals(settingValueRaw)) continue;
                        li.set(settingValueResolved);
                        changed = true;
                    }
                    if (!changed) continue;
                    entry.setValue(List.copyOf(mutableList));
                    continue;
                }
                String value = propertyPlaceholder.replacePlaceholders(Settings.toString(entry.getValue()), placeholderResolver);
                if (Strings.hasLength(value)) {
                    entry.setValue(value);
                    continue;
                }
                entryItr.remove();
            }
            return this;
        }

        public Builder normalizePrefix(String prefix) {
            HashMap<CallSite, Object> replacements = new HashMap<CallSite, Object>();
            Iterator<Map.Entry<String, Object>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                if (key.startsWith(prefix) || key.endsWith("*")) continue;
                replacements.put((CallSite)((Object)(prefix + key)), entry.getValue());
                iterator.remove();
            }
            this.map.putAll(replacements);
            return this;
        }

        public Settings build() {
            SecureSettings secSettings = (SecureSettings)this.secureSettings.get();
            if (secSettings == null && this.map.isEmpty()) {
                return EMPTY;
            }
            this.processLegacyLists(this.map);
            return new Settings(this.map, secSettings);
        }
    }

    private record SettingsDiff(DiffableUtils.MapDiff<String, Object, Map<String, Object>> mapDiff) implements Diff<Settings>
    {
        @Override
        public Settings apply(Settings part) {
            NavigableMap<String, Object> updated = this.mapDiff.apply(part.settings);
            if (updated == part.settings) {
                return part;
            }
            return Settings.of(updated, null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.mapDiff.writeTo(out);
        }
    }

    static class DeprecationLoggerHolder {
        static DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(Settings.class);

        DeprecationLoggerHolder() {
        }
    }
}

