/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public final class ByteUtils
extends Enum<ByteUtils> {
    public static final VarHandle LITTLE_ENDIAN_CHAR;
    public static final VarHandle LITTLE_ENDIAN_INT;
    public static final VarHandle LITTLE_ENDIAN_LONG;
    public static final VarHandle BIG_ENDIAN_LONG;
    private static final VarHandle BIG_ENDIAN_SHORT;
    private static final VarHandle BIG_ENDIAN_INT;
    private static final /* synthetic */ ByteUtils[] $VALUES;

    public static ByteUtils[] values() {
        return (ByteUtils[])$VALUES.clone();
    }

    public static ByteUtils valueOf(String name) {
        return Enum.valueOf(ByteUtils.class, name);
    }

    public static long zigZagDecode(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static long zigZagEncode(long n) {
        return n >> 63 ^ n << 1;
    }

    public static void writeLongLE(long val, byte[] arr, int offset) {
        LITTLE_ENDIAN_LONG.set(arr, offset, val);
    }

    public static long readLongLE(byte[] arr, int offset) {
        return LITTLE_ENDIAN_LONG.get(arr, offset);
    }

    public static void writeLongBE(long val, byte[] arr, int offset) {
        BIG_ENDIAN_LONG.set(arr, offset, val);
    }

    public static long readLongBE(byte[] arr, int offset) {
        return BIG_ENDIAN_LONG.get(arr, offset);
    }

    public static void writeIntLE(int val, byte[] arr, int offset) {
        LITTLE_ENDIAN_INT.set(arr, offset, val);
    }

    public static int readIntLE(byte[] arr, int offset) {
        return LITTLE_ENDIAN_INT.get(arr, offset);
    }

    public static void writeDoubleLE(double val, byte[] arr, int offset) {
        ByteUtils.writeLongLE(Double.doubleToRawLongBits(val), arr, offset);
    }

    public static double readDoubleLE(byte[] arr, int offset) {
        return Double.longBitsToDouble(ByteUtils.readLongLE(arr, offset));
    }

    public static void writeFloatLE(float val, byte[] arr, int offset) {
        ByteUtils.writeIntLE(Float.floatToRawIntBits(val), arr, offset);
    }

    public static float readFloatLE(byte[] arr, int offset) {
        return Float.intBitsToFloat(ByteUtils.readIntLE(arr, offset));
    }

    public static void writeIntBE(int val, byte[] arr, int offset) {
        BIG_ENDIAN_INT.set(arr, offset, val);
    }

    public static int readIntBE(byte[] arr, int offset) {
        return BIG_ENDIAN_INT.get(arr, offset);
    }

    public static void writeShortBE(short val, byte[] arr, int offset) {
        BIG_ENDIAN_SHORT.set(arr, offset, val);
    }

    public static short readShortBE(byte[] arr, int offset) {
        return BIG_ENDIAN_SHORT.get(arr, offset);
    }

    private static /* synthetic */ ByteUtils[] $values() {
        return new ByteUtils[0];
    }

    static {
        $VALUES = ByteUtils.$values();
        LITTLE_ENDIAN_CHAR = MethodHandles.byteArrayViewVarHandle(char[].class, ByteOrder.LITTLE_ENDIAN);
        LITTLE_ENDIAN_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
        LITTLE_ENDIAN_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
        BIG_ENDIAN_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
        BIG_ENDIAN_SHORT = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
        BIG_ENDIAN_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
    }
}

