/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Arrays;
import java.util.Base64;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.Numbers;

public final class Uid {
    public static final byte DELIMITER_BYTE = 35;
    private static final int UTF8 = 255;
    private static final int NUMERIC = 254;
    private static final int BASE64_ESCAPE = 253;

    private Uid() {
    }

    static boolean isURLBase64WithoutPadding(String id) {
        int length = id.length();
        switch (length & 3) {
            case 0: {
                break;
            }
            case 1: {
                return false;
            }
            case 2: {
                char last = id.charAt(length - 1);
                if (last == 'A' || last == 'Q' || last == 'g' || last == 'w') break;
                return false;
            }
            case 3: {
                char last = id.charAt(length - 1);
                if (last == 'A' || last == 'E' || last == 'I' || last == 'M' || last == 'Q' || last == 'U' || last == 'Y' || last == 'c' || last == 'g' || last == 'k' || last == 'o' || last == 's' || last == 'w' || last == '0' || last == '4' || last == '8') break;
                return false;
            }
            default: {
                throw new AssertionError((Object)"Impossible case");
            }
        }
        for (int i = 0; i < length; ++i) {
            boolean allowed;
            char c = id.charAt(i);
            boolean bl = allowed = c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '_';
            if (allowed) continue;
            return false;
        }
        return true;
    }

    private static BytesRef encodeNumericId(String id) {
        byte[] b = new byte[1 + (id.length() + 1) / 2];
        b[0] = -2;
        for (int i = 0; i < id.length(); i += 2) {
            int b1 = id.charAt(i) - 48;
            int b2 = i + 1 == id.length() ? 15 : id.charAt(i + 1) - 48;
            b[1 + i / 2] = (byte)(b1 << 4 | b2);
        }
        return new BytesRef(b);
    }

    private static BytesRef encodeBase64Id(String id) {
        byte[] b = Base64.getUrlDecoder().decode(id);
        if (Byte.toUnsignedInt(b[0]) >= 253) {
            byte[] newB = new byte[b.length + 1];
            newB[0] = -3;
            System.arraycopy(b, 0, newB, 1, b.length);
            b = newB;
        }
        return new BytesRef(b, 0, b.length);
    }

    private static BytesRef encodeUtf8Id(String id) {
        byte[] b = new byte[1 + UnicodeUtil.calcUTF16toUTF8Length((CharSequence)id, (int)0, (int)id.length())];
        b[0] = -1;
        int length = UnicodeUtil.UTF16toUTF8((CharSequence)id, (int)0, (int)id.length(), (byte[])b, (int)1);
        return new BytesRef(b, 0, length);
    }

    public static BytesRef encodeId(String id) {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Ids can't be empty");
        }
        if (Numbers.isPositiveNumeric(id)) {
            return Uid.encodeNumericId(id);
        }
        if (Uid.isURLBase64WithoutPadding(id)) {
            return Uid.encodeBase64Id(id);
        }
        return Uid.encodeUtf8Id(id);
    }

    private static String decodeNumericId(byte[] idBytes, int offset, int len) {
        assert (Byte.toUnsignedInt(idBytes[offset]) == 254);
        int length = (len - 1) * 2;
        char[] chars = new char[length];
        for (int i = 1; i < len; ++i) {
            int b = Byte.toUnsignedInt(idBytes[offset + i]);
            int b1 = b >>> 4;
            int b2 = b & 0xF;
            chars[(i - 1) * 2] = (char)(b1 + 48);
            if (i == len - 1 && b2 == 15) {
                --length;
                break;
            }
            chars[(i - 1) * 2 + 1] = (char)(b2 + 48);
        }
        return new String(chars, 0, length);
    }

    private static String decodeUtf8Id(byte[] idBytes, int offset, int length) {
        assert (Byte.toUnsignedInt(idBytes[offset]) == 255);
        return new BytesRef(idBytes, offset + 1, length - 1).utf8ToString();
    }

    private static String decodeBase64Id(byte[] idBytes, int offset, int length) {
        assert (Byte.toUnsignedInt(idBytes[offset]) <= 253);
        if (Byte.toUnsignedInt(idBytes[offset]) == 253) {
            idBytes = Arrays.copyOfRange(idBytes, offset + 1, offset + length);
        } else if (!(idBytes.length == length && offset == 0)) {
            idBytes = Arrays.copyOfRange(idBytes, offset, offset + length);
        }
        return Base64.getUrlEncoder().withoutPadding().encodeToString(idBytes);
    }

    public static String decodeId(byte[] idBytes) {
        return Uid.decodeId(idBytes, 0, idBytes.length);
    }

    public static String decodeId(byte[] idBytes, int offset, int length) {
        if (length == 0) {
            throw new IllegalArgumentException("Ids can't be empty");
        }
        int magicChar = Byte.toUnsignedInt(idBytes[offset]);
        return switch (magicChar) {
            case 254 -> Uid.decodeNumericId(idBytes, offset, length);
            case 255 -> Uid.decodeUtf8Id(idBytes, offset, length);
            default -> Uid.decodeBase64Id(idBytes, offset, length);
        };
    }
}

