/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.MultiVectorIndexFieldData;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.vectors.VectorData;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class MultiDenseVectorFieldMapper
extends FieldMapper {
    public static final String VECTOR_MAGNITUDES_SUFFIX = "._magnitude";
    public static final FeatureFlag FEATURE_FLAG = new FeatureFlag("multi_dense_vector");
    public static final String CONTENT_TYPE = "multi_dense_vector";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated()), MultiDenseVectorFieldMapper.notInMultiFields("multi_dense_vector"));
    private final IndexVersion indexCreatedVersion;

    private static MultiDenseVectorFieldMapper toType(FieldMapper in) {
        return (MultiDenseVectorFieldMapper)in;
    }

    private MultiDenseVectorFieldMapper(String simpleName, MappedFieldType fieldType, FieldMapper.BuilderParams params, IndexVersion indexCreatedVersion) {
        super(simpleName, fieldType, params);
        this.indexCreatedVersion = indexCreatedVersion;
    }

    @Override
    public MultiDenseVectorFieldType fieldType() {
        return (MultiDenseVectorFieldType)super.fieldType();
    }

    @Override
    public boolean parsesArrayValue() {
        return true;
    }

    @Override
    public void parse(DocumentParserContext context) throws IOException {
        if (context.doc().getByKey(this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support indexing multiple values for the same field in the same document");
        }
        if (XContentParser.Token.VALUE_NULL == context.parser().currentToken()) {
            return;
        }
        if (XContentParser.Token.START_ARRAY != context.parser().currentToken()) {
            throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] cannot be indexed with a single value");
        }
        if (this.fieldType().dims == null) {
            int currentDims = -1;
            while (XContentParser.Token.END_ARRAY != context.parser().nextToken()) {
                int dims = this.fieldType().elementType.parseDimensionCount(context);
                if (currentDims == -1) {
                    currentDims = dims;
                    continue;
                }
                if (currentDims == dims) continue;
                throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] cannot be indexed with vectors of different dimensions");
            }
            MultiDenseVectorFieldType updatedFieldType = new MultiDenseVectorFieldType(this.fieldType().name(), this.fieldType().elementType, currentDims, this.indexCreatedVersion, this.fieldType().meta());
            MultiDenseVectorFieldMapper update = new MultiDenseVectorFieldMapper(this.leafName(), updatedFieldType, this.builderParams, this.indexCreatedVersion);
            context.addDynamicMapper(update);
            return;
        }
        int dims = this.fieldType().dims;
        DenseVectorFieldMapper.ElementType elementType = this.fieldType().elementType;
        ArrayList<VectorData> vectors = new ArrayList<VectorData>();
        while (XContentParser.Token.END_ARRAY != context.parser().nextToken()) {
            VectorData vector = elementType.parseKnnVector(context, dims, (i, b) -> {
                if (b) {
                    this.checkDimensionMatches(i, context);
                } else {
                    this.checkDimensionExceeded(i, context);
                }
            }, null);
            vectors.add(vector);
        }
        int bufferSize = elementType.getNumBytes(dims) * vectors.size();
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer magnitudeBuffer = ByteBuffer.allocate(vectors.size() * 4).order(ByteOrder.LITTLE_ENDIAN);
        for (VectorData vector : vectors) {
            vector.addToBuffer(buffer);
            magnitudeBuffer.putFloat((float)Math.sqrt(elementType.computeSquaredMagnitude(vector)));
        }
        String vectorFieldName = this.fieldType().name();
        String vectorMagnitudeFieldName = vectorFieldName + VECTOR_MAGNITUDES_SUFFIX;
        context.doc().addWithKey(vectorFieldName, (IndexableField)new BinaryDocValuesField(vectorFieldName, new BytesRef(buffer.array())));
        context.doc().addWithKey(vectorMagnitudeFieldName, (IndexableField)new BinaryDocValuesField(vectorMagnitudeFieldName, new BytesRef(magnitudeBuffer.array())));
    }

    private void checkDimensionExceeded(int index, DocumentParserContext context) {
        if (index >= this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.fullPath() + "] in doc [" + context.documentDescription() + "] has more dimensions than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    private void checkDimensionMatches(int index, DocumentParserContext context) {
        if (index != this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.fullPath() + "] in doc [" + context.documentDescription() + "] has a different number of dimensions [" + index + "] than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion).init(this);
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(new DocValuesSyntheticFieldLoader());
    }

    public static final class MultiDenseVectorFieldType
    extends SimpleMappedFieldType {
        private final DenseVectorFieldMapper.ElementType elementType;
        private final Integer dims;
        private final IndexVersion indexCreatedVersion;

        public MultiDenseVectorFieldType(String name, DenseVectorFieldMapper.ElementType elementType, Integer dims, IndexVersion indexCreatedVersion, Map<String, String> meta) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
            this.elementType = elementType;
            this.dims = dims;
            this.indexCreatedVersion = indexCreatedVersion;
        }

        @Override
        public String typeName() {
            return MultiDenseVectorFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        @Override
        public boolean isAggregatable() {
            return false;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return new MultiVectorIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD, this.indexCreatedVersion, this.dims, this.elementType);
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            return new FieldExistsQuery(this.name());
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support term queries");
        }

        int getVectorDimensions() {
            return this.dims;
        }

        DenseVectorFieldMapper.ElementType getElementType() {
            return this.elementType;
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<DenseVectorFieldMapper.ElementType> elementType = new FieldMapper.Parameter<DenseVectorFieldMapper.ElementType>("element_type", false, () -> DenseVectorFieldMapper.ElementType.FLOAT, (n, c, o) -> {
            DenseVectorFieldMapper.ElementType elementType = DenseVectorFieldMapper.namesToElementType.get((String)o);
            if (elementType == null) {
                throw new MapperParsingException("invalid element_type [" + o + "]; available types are " + DenseVectorFieldMapper.namesToElementType.keySet());
            }
            return elementType;
        }, m -> MultiDenseVectorFieldMapper.toType((FieldMapper)m).fieldType().elementType, XContentBuilder::field, Objects::toString);
        private final FieldMapper.Parameter<Integer> dims = new FieldMapper.Parameter<Integer>("dims", true, () -> null, (n, c, o) -> {
            if (!(o instanceof Integer)) {
                throw new MapperParsingException("Property [dims] on field [" + n + "] must be an integer but got [" + o + "]");
            }
            return XContentMapValues.nodeIntegerValue(o);
        }, m -> MultiDenseVectorFieldMapper.toType((FieldMapper)m).fieldType().dims, XContentBuilder::field, Object::toString).setSerializerCheck((id, ic, v) -> v != null).setMergeValidator((previous, current, c) -> previous == null || Objects.equals(previous, current)).addValidator(dims -> {
            int minDims;
            if (dims == null) {
                return;
            }
            int maxDims = this.elementType.getValue() == DenseVectorFieldMapper.ElementType.BIT ? DenseVectorFieldMapper.MAX_DIMS_COUNT_BIT : (int)DenseVectorFieldMapper.MAX_DIMS_COUNT;
            int n = minDims = this.elementType.getValue() == DenseVectorFieldMapper.ElementType.BIT ? 8 : 1;
            if (dims < minDims || dims > maxDims) {
                throw new MapperParsingException("The number of dimensions should be in the range [" + minDims + ", " + maxDims + "] but was [" + dims + "]");
            }
            if (this.elementType.getValue() == DenseVectorFieldMapper.ElementType.BIT && dims % 8 != 0) {
                throw new MapperParsingException("The number of dimensions for should be a multiple of 8 but was [" + dims + "]");
            }
        });
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final IndexVersion indexCreatedVersion;

        public Builder(String name, IndexVersion indexCreatedVersion) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.elementType, this.dims, this.meta};
        }

        public Builder dimensions(int dimensions) {
            this.dims.setValue(dimensions);
            return this;
        }

        public Builder elementType(DenseVectorFieldMapper.ElementType elementType) {
            this.elementType.setValue(elementType);
            return this;
        }

        @Override
        public MultiDenseVectorFieldMapper build(MapperBuilderContext context) {
            this.validate();
            return new MultiDenseVectorFieldMapper(this.leafName(), new MultiDenseVectorFieldType(context.buildFullName(this.leafName()), this.elementType.getValue(), this.dims.getValue(), this.indexCreatedVersion, this.meta.getValue()), this.builderParams(this, context), this.indexCreatedVersion);
        }
    }

    private class DocValuesSyntheticFieldLoader
    extends SourceLoader.DocValuesBasedSyntheticFieldLoader {
        private BinaryDocValues values;
        private boolean hasValue;

        private DocValuesSyntheticFieldLoader() {
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.values = leafReader.getBinaryDocValues(MultiDenseVectorFieldMapper.this.fullPath());
            if (this.values == null) {
                return null;
            }
            return docId -> {
                this.hasValue = docId == this.values.advance(docId);
                return this.hasValue;
            };
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            b.startArray(MultiDenseVectorFieldMapper.this.leafName());
            BytesRef ref = this.values.binaryValue();
            ByteBuffer byteBuffer = ByteBuffer.wrap(ref.bytes, ref.offset, ref.length).order(ByteOrder.LITTLE_ENDIAN);
            assert (ref.length % MultiDenseVectorFieldMapper.this.fieldType().elementType.getNumBytes(MultiDenseVectorFieldMapper.this.fieldType().dims) == 0);
            int numVecs = ref.length / MultiDenseVectorFieldMapper.this.fieldType().elementType.getNumBytes(MultiDenseVectorFieldMapper.this.fieldType().dims);
            for (int i = 0; i < numVecs; ++i) {
                b.startArray();
                int dims = MultiDenseVectorFieldMapper.this.fieldType().elementType == DenseVectorFieldMapper.ElementType.BIT ? MultiDenseVectorFieldMapper.this.fieldType().dims / 8 : MultiDenseVectorFieldMapper.this.fieldType().dims;
                for (int dim = 0; dim < dims; ++dim) {
                    MultiDenseVectorFieldMapper.this.fieldType().elementType.readAndWriteValue(byteBuffer, b);
                }
                b.endArray();
            }
            b.endArray();
        }

        @Override
        public String fieldName() {
            return MultiDenseVectorFieldMapper.this.fullPath();
        }
    }
}

