/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.vectors.MultiDenseVector;

public class MultiDenseVectorScriptDocValues
extends ScriptDocValues<BytesRef> {
    public static final String MISSING_VECTOR_FIELD_MESSAGE = "A document doesn't have a value for a multi-vector field!";
    private final int dims;
    protected final MultiDenseVectorSupplier dvSupplier;

    public MultiDenseVectorScriptDocValues(MultiDenseVectorSupplier supplier, int dims) {
        super(supplier);
        this.dvSupplier = supplier;
        this.dims = dims;
    }

    public int dims() {
        return this.dims;
    }

    private MultiDenseVector getCheckedVector() {
        MultiDenseVector vector = this.dvSupplier.getInternal();
        if (vector == null) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }
        return vector;
    }

    public Iterator<float[]> getVectorValues() {
        return this.getCheckedVector().getVectors();
    }

    public float[] getMagnitudes() {
        return this.getCheckedVector().getMagnitudes();
    }

    @Override
    public BytesRef get(int index) {
        throw new UnsupportedOperationException("accessing a multi-vector field's value through 'get' or 'value' is not supported, use 'vectorValues' or 'magnitudes' instead.");
    }

    @Override
    public int size() {
        MultiDenseVector mdv = this.dvSupplier.getInternal();
        if (mdv != null) {
            return mdv.size();
        }
        return 0;
    }

    public static interface MultiDenseVectorSupplier
    extends ScriptDocValues.Supplier<BytesRef> {
        @Override
        default public BytesRef getInternal(int index) {
            throw new UnsupportedOperationException();
        }

        public MultiDenseVector getInternal();
    }
}

