/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DisMaxQueryBuilder
extends AbstractQueryBuilder<DisMaxQueryBuilder> {
    public static final String NAME = "dis_max";
    public static final float DEFAULT_TIE_BREAKER = 0.0f;
    private static final ParseField TIE_BREAKER_FIELD = new ParseField("tie_breaker", new String[0]);
    private static final ParseField QUERIES_FIELD = new ParseField("queries", new String[0]);
    private final List<QueryBuilder> queries = new ArrayList<QueryBuilder>();
    private float tieBreaker = 0.0f;

    public DisMaxQueryBuilder() {
    }

    public DisMaxQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queries.addAll(DisMaxQueryBuilder.readQueries(in));
        this.tieBreaker = in.readFloat();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        DisMaxQueryBuilder.writeQueries(out, this.queries);
        out.writeFloat(this.tieBreaker);
    }

    public DisMaxQueryBuilder add(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner dismax query clause cannot be null");
        }
        this.queries.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> innerQueries() {
        return this.queries;
    }

    public DisMaxQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public float tieBreaker() {
        return this.tieBreaker;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(TIE_BREAKER_FIELD.getPreferredName(), this.tieBreaker);
        builder.startArray(QUERIES_FIELD.getPreferredName());
        for (QueryBuilder queryBuilder : this.queries) {
            queryBuilder.toXContent(builder, params);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static DisMaxQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        float tieBreaker = 0.0f;
        ArrayList<QueryBuilder> queries = new ArrayList<QueryBuilder>();
        boolean queriesFound = false;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERIES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queriesFound = true;
                    queries.add(DisMaxQueryBuilder.parseInnerQueryBuilder(parser));
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[dis_max] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (QUERIES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queriesFound = true;
                    while (token != XContentParser.Token.END_ARRAY) {
                        queries.add(DisMaxQueryBuilder.parseInnerQueryBuilder(parser));
                        token = parser.nextToken();
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[dis_max] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (TIE_BREAKER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                tieBreaker = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[dis_max] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!queriesFound) {
            throw new ParsingException(parser.getTokenLocation(), "[dis_max] requires 'queries' field with at least one clause", new Object[0]);
        }
        DisMaxQueryBuilder disMaxQuery = new DisMaxQueryBuilder();
        disMaxQuery.tieBreaker(tieBreaker);
        disMaxQuery.queryName(queryName);
        disMaxQuery.boost(boost);
        for (QueryBuilder query : queries) {
            disMaxQuery.add(query);
        }
        return disMaxQuery;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        Collection<Query> luceneQueries = DisMaxQueryBuilder.toQueries(this.queries, context);
        if (luceneQueries.isEmpty()) {
            return Queries.newMatchNoDocsQuery("no clauses for dismax query.");
        }
        return new DisjunctionMaxQuery(luceneQueries, this.tieBreaker);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        DisMaxQueryBuilder newBuilder = new DisMaxQueryBuilder();
        boolean changed = false;
        for (QueryBuilder query : this.queries) {
            QueryBuilder result = query.rewrite(queryRewriteContext);
            if (result != query) {
                changed = true;
            }
            newBuilder.add(result);
        }
        if (changed) {
            newBuilder.queryName(this.queryName);
            newBuilder.boost(this.boost);
            newBuilder.tieBreaker(this.tieBreaker);
            return newBuilder;
        }
        return this;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.queries, Float.valueOf(this.tieBreaker));
    }

    @Override
    protected boolean doEquals(DisMaxQueryBuilder other) {
        return Objects.equals(this.queries, other.queries) && Objects.equals(Float.valueOf(this.tieBreaker), Float.valueOf(other.tieBreaker));
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        for (QueryBuilder query : this.queries) {
            InnerHitContextBuilder.extractInnerHits(query, innerHits);
        }
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }
}

